/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    private final RegistryInfoLookup lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, HolderLookup.Provider var1) {
        return RegistryOps.create(var0, new HolderLookupAdapter(var1));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, RegistryInfoLookup var1) {
        return new RegistryOps<T>(var0, var1);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> var0, HolderLookup.Provider var1) {
        return new Dynamic(var1.createSerializationContext(var0.getOps()), var0.getValue());
    }

    private RegistryOps(DynamicOps<T> var0, RegistryInfoLookup var1) {
        super(var0);
        this.lookupProvider = var1;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> var0) {
        if (var0 == this.delegate) {
            return this;
        }
        return new RegistryOps<U>(var0, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends Registry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(RegistryInfo::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends Registry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(RegistryInfo::getter);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        RegistryOps var1 = (RegistryOps)var0;
        return this.delegate.equals((Object)var1.delegate) && this.lookupProvider.equals(var1.lookupProvider);
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends Registry<? extends E>> var02) {
        return ExtraCodecs.retrieveContext(var1 -> {
            if (var1 instanceof RegistryOps) {
                RegistryOps var2 = (RegistryOps)var1;
                return var2.lookupProvider.lookup(var02).map(var0 -> DataResult.success(var0.getter(), (Lifecycle)var0.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(var02)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(var0 -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> retrieveElement(ResourceKey<E> var02) {
        ResourceKey var1 = ResourceKey.createRegistryKey(var02.registry());
        return ExtraCodecs.retrieveContext(var2 -> {
            if (var2 instanceof RegistryOps) {
                RegistryOps var3 = (RegistryOps)var2;
                return var3.lookupProvider.lookup(var1).flatMap(var1 -> var1.getter().get(var02)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(var02)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(var0 -> null);
    }

    static final class HolderLookupAdapter
    implements RegistryInfoLookup {
        private final HolderLookup.Provider lookupProvider;
        private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> lookups = new ConcurrentHashMap();

        public HolderLookupAdapter(HolderLookup.Provider var0) {
            this.lookupProvider = var0;
        }

        public <E> Optional<RegistryInfo<E>> lookup(ResourceKey<? extends Registry<? extends E>> var0) {
            return this.lookups.computeIfAbsent(var0, this::createLookup);
        }

        private Optional<RegistryInfo<Object>> createLookup(ResourceKey<? extends Registry<?>> var0) {
            return this.lookupProvider.lookup(var0).map(RegistryInfo::fromRegistryLookup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (!(var0 instanceof HolderLookupAdapter)) return false;
            HolderLookupAdapter var1 = (HolderLookupAdapter)var0;
            if (!this.lookupProvider.equals(var1.lookupProvider)) return false;
            return true;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> RegistryInfo<T> fromRegistryLookup(HolderLookup.RegistryLookup<T> var0) {
            return new RegistryInfo<T>(var0, var0, var0.registryLifecycle());
        }
    }
}

