/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.tags.TagLoader;
import org.slf4j.Logger;

public class ServerFunctionLibrary
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Registry<CommandFunction<CommandSourceStack>>> TYPE_KEY = ResourceKey.createRegistryKey(Identifier.withDefaultNamespace("function"));
    private static final FileToIdConverter LISTER = new FileToIdConverter(Registries.elementsDirPath(TYPE_KEY), ".mcfunction");
    private volatile Map<Identifier, CommandFunction<CommandSourceStack>> functions = ImmutableMap.of();
    private final TagLoader<CommandFunction<CommandSourceStack>> tagsLoader = new TagLoader((var0, var1) -> this.getFunction(var0), Registries.tagsDirPath(TYPE_KEY));
    private volatile Map<Identifier, List<CommandFunction<CommandSourceStack>>> tags = Map.of();
    private final PermissionSet functionCompilationPermissions;
    private final CommandDispatcher<CommandSourceStack> dispatcher;

    public Optional<CommandFunction<CommandSourceStack>> getFunction(Identifier var0) {
        return Optional.ofNullable(this.functions.get(var0));
    }

    public Map<Identifier, CommandFunction<CommandSourceStack>> getFunctions() {
        return this.functions;
    }

    public List<CommandFunction<CommandSourceStack>> getTag(Identifier var0) {
        return this.tags.getOrDefault(var0, List.of());
    }

    public Iterable<Identifier> getAvailableTags() {
        return this.tags.keySet();
    }

    public ServerFunctionLibrary(PermissionSet var02, CommandDispatcher<CommandSourceStack> var12) {
        this.functionCompilationPermissions = var02;
        this.dispatcher = var12;
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.SharedState var02, Executor var1, PreparableReloadListener.PreparationBarrier var2, Executor var3) {
        ResourceManager var4 = var02.resourceManager();
        CompletableFuture<Map> var5 = CompletableFuture.supplyAsync(() -> this.tagsLoader.load(var4), var1);
        CompletionStage var6 = CompletableFuture.supplyAsync(() -> LISTER.listMatchingResources(var4), var1).thenCompose(var12 -> {
            HashMap var22 = Maps.newHashMap();
            CommandSourceStack var3 = Commands.createCompilationContext(this.functionCompilationPermissions);
            for (Map.Entry var5 : var12.entrySet()) {
                Identifier var6 = (Identifier)var5.getKey();
                Identifier var7 = LISTER.fileToId(var6);
                var22.put(var7, CompletableFuture.supplyAsync(() -> {
                    List<String> var3 = ServerFunctionLibrary.readLines((Resource)var5.getValue());
                    return CommandFunction.fromLines(var7, this.dispatcher, var3, var3);
                }, var1));
            }
            CompletableFuture[] var4 = var22.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(var4).handle((var1, var2) -> var22);
        });
        return ((CompletableFuture)((CompletableFuture)var5.thenCombine(var6, Pair::of)).thenCompose(var2::wait)).thenAcceptAsync(var0 -> {
            Map var12 = (Map)var0.getSecond();
            ImmutableMap.Builder var2 = ImmutableMap.builder();
            var12.forEach((var1, var22) -> ((CompletableFuture)var22.handle((var2, var3) -> {
                if (var3 != null) {
                    LOGGER.error("Failed to load function {}", var1, var3);
                } else {
                    var2.put(var1, var2);
                }
                return null;
            })).join());
            this.functions = var2.build();
            this.tags = this.tagsLoader.build((Map)var0.getFirst());
        }, var3);
    }

    private static List<String> readLines(Resource var0) {
        List<String> list;
        block8: {
            BufferedReader var1 = var0.openAsReader();
            try {
                list = var1.lines().toList();
                if (var1 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var1 != null) {
                        try {
                            var1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException var12) {
                    throw new CompletionException(var12);
                }
            }
            var1.close();
        }
        return list;
    }
}

