/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ServerFunctionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Identifier TICK_FUNCTION_TAG = Identifier.withDefaultNamespace("tick");
    private static final Identifier LOAD_FUNCTION_TAG = Identifier.withDefaultNamespace("load");
    private final MinecraftServer server;
    private List<CommandFunction<CommandSourceStack>> ticking = ImmutableList.of();
    private boolean postReload;
    private ServerFunctionLibrary library;

    public ServerFunctionManager(MinecraftServer minecraftserver, ServerFunctionLibrary customfunctionmanager) {
        this.server = minecraftserver;
        this.library = customfunctionmanager;
        this.postReload(customfunctionmanager);
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.server.vanillaCommandDispatcher.getDispatcher();
    }

    public void tick() {
        if (this.server.tickRateManager().runsNormally()) {
            if (this.postReload) {
                this.postReload = false;
                List<CommandFunction<CommandSourceStack>> collection = this.library.getTag(LOAD_FUNCTION_TAG);
                this.executeTagFunctions(collection, LOAD_FUNCTION_TAG);
            }
            this.executeTagFunctions(this.ticking, TICK_FUNCTION_TAG);
        }
    }

    private void executeTagFunctions(Collection<CommandFunction<CommandSourceStack>> collection, Identifier minecraftkey) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        Objects.requireNonNull(minecraftkey);
        gameprofilerfiller.push(minecraftkey::toString);
        for (CommandFunction<CommandSourceStack> commandfunction : collection) {
            this.execute(commandfunction, this.getGameLoopSender());
        }
        Profiler.get().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandFunction<CommandSourceStack> commandfunction, CommandSourceStack commandlistenerwrapper) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push(() -> "function " + String.valueOf(commandfunction.id()));
        try {
            InstantiatedFunction<CommandSourceStack> instantiatedfunction = commandfunction.instantiate(null, this.getDispatcher());
            Commands.executeCommandInContext(commandlistenerwrapper, executioncontext -> ExecutionContext.queueInitialFunctionCall(executioncontext, instantiatedfunction, commandlistenerwrapper, CommandResultCallback.EMPTY));
        }
        catch (FunctionInstantiationException instantiatedfunction) {
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to execute function {}", (Object)commandfunction.id(), (Object)exception);
        }
        finally {
            gameprofilerfiller.pop();
        }
    }

    public void replaceLibrary(ServerFunctionLibrary customfunctionmanager) {
        this.library = customfunctionmanager;
        this.postReload(customfunctionmanager);
    }

    private void postReload(ServerFunctionLibrary customfunctionmanager) {
        this.ticking = List.copyOf(customfunctionmanager.getTag(TICK_FUNCTION_TAG));
        this.postReload = true;
    }

    public CommandSourceStack getGameLoopSender() {
        return this.server.createCommandSourceStack().withPermission(LevelBasedPermissionSet.GAMEMASTER).withSuppressedOutput();
    }

    public Optional<CommandFunction<CommandSourceStack>> get(Identifier minecraftkey) {
        return this.library.getFunction(minecraftkey);
    }

    public List<CommandFunction<CommandSourceStack>> getTag(Identifier minecraftkey) {
        return this.library.getTag(minecraftkey);
    }

    public Iterable<Identifier> getFunctionNames() {
        return this.library.getFunctions().keySet();
    }

    public Iterable<Identifier> getTagNames() {
        return this.library.getAvailableTags();
    }
}

