/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> load(InitConfig var0, WorldDataSupplier<D> var12, ResultFactory<D, R> var22, Executor var3, Executor var42) {
        try {
            Pair<WorldDataConfiguration, CloseableResourceManager> var5 = var0.packConfig.createResourceManager();
            CloseableResourceManager var6 = (CloseableResourceManager)var5.getSecond();
            LayeredRegistryAccess<RegistryLayer> var7 = RegistryLayer.createRegistryAccess();
            List<Registry.PendingTags<?>> var8 = TagLoader.loadTagsForExistingRegistries(var6, var7.getLayer(RegistryLayer.STATIC));
            RegistryAccess.Frozen var9 = var7.getAccessForLoading(RegistryLayer.WORLDGEN);
            List<HolderLookup.RegistryLookup<?>> var10 = TagLoader.buildUpdatedLookups(var9, var8);
            RegistryAccess.Frozen var11 = RegistryDataLoader.load(var6, var10, RegistryDataLoader.WORLDGEN_REGISTRIES);
            List<HolderLookup.RegistryLookup<?>> var122 = Stream.concat(var10.stream(), var11.listRegistries()).toList();
            RegistryAccess.Frozen var13 = RegistryDataLoader.load(var6, var122, RegistryDataLoader.DIMENSION_REGISTRIES);
            WorldDataConfiguration var14 = (WorldDataConfiguration)var5.getFirst();
            HolderLookup.Provider var15 = HolderLookup.Provider.create(var122.stream());
            DataLoadOutput<D> var16 = var12.get(new DataLoadContext(var6, var14, var15, var13));
            LayeredRegistryAccess<RegistryLayer> var17 = var7.replaceFrom(RegistryLayer.WORLDGEN, var11, var16.finalDimensions);
            return ((CompletableFuture)ReloadableServerResources.loadResources(var6, var17, var8, var14.enabledFeatures(), var0.commandSelection(), var0.functionCompilationPermissions(), var3, var42).whenComplete((var1, var2) -> {
                if (var2 != null) {
                    var6.close();
                }
            })).thenApplyAsync(var4 -> {
                var4.updateStaticRegistryTags();
                return var22.create(var6, (ReloadableServerResources)var4, var17, var3.cookie);
            }, var42);
        }
        catch (Exception var5) {
            return CompletableFuture.failedFuture(var5);
        }
    }

    public static final class InitConfig
    extends Record {
        final PackConfig packConfig;
        private final Commands.CommandSelection commandSelection;
        private final PermissionSet functionCompilationPermissions;

        public InitConfig(PackConfig var0, Commands.CommandSelection var1, PermissionSet var2) {
            this.packConfig = var0;
            this.commandSelection = var1;
            this.functionCompilationPermissions = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationPermissions", "packConfig", "commandSelection", "functionCompilationPermissions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationPermissions", "packConfig", "commandSelection", "functionCompilationPermissions"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InitConfig.class, "packConfig;commandSelection;functionCompilationPermissions", "packConfig", "commandSelection", "functionCompilationPermissions"}, this, var0);
        }

        public PackConfig packConfig() {
            return this.packConfig;
        }

        public Commands.CommandSelection commandSelection() {
            return this.commandSelection;
        }

        public PermissionSet functionCompilationPermissions() {
            return this.functionCompilationPermissions;
        }
    }

    public record PackConfig(PackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean safeMode, boolean initMode) {
        public Pair<WorldDataConfiguration, CloseableResourceManager> createResourceManager() {
            WorldDataConfiguration var0 = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataConfig, this.initMode, this.safeMode);
            List<PackResources> var1 = this.packRepository.openAllSelected();
            MultiPackResourceManager var2 = new MultiPackResourceManager(PackType.SERVER_DATA, var1);
            return Pair.of((Object)var0, (Object)var2);
        }
    }

    public record DataLoadContext(ResourceManager resources, WorldDataConfiguration dataConfiguration, HolderLookup.Provider datapackWorldgen, RegistryAccess.Frozen datapackDimensions) {
    }

    @FunctionalInterface
    public static interface WorldDataSupplier<D> {
        public DataLoadOutput<D> get(DataLoadContext var1);
    }

    public static final class DataLoadOutput<D>
    extends Record {
        final D cookie;
        final RegistryAccess.Frozen finalDimensions;

        public DataLoadOutput(D var0, RegistryAccess.Frozen var1) {
            this.cookie = var0;
            this.finalDimensions = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DataLoadOutput.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this, var0);
        }

        public D cookie() {
            return this.cookie;
        }

        public RegistryAccess.Frozen finalDimensions() {
            return this.finalDimensions;
        }
    }

    @FunctionalInterface
    public static interface ResultFactory<D, R> {
        public R create(CloseableResourceManager var1, ReloadableServerResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

