/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CustomBossEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Identifier, CustomBossEvent.Packed>> EVENTS_CODEC = Codec.unboundedMap(Identifier.CODEC, CustomBossEvent.Packed.CODEC);
    private final Map<Identifier, CustomBossEvent> events = Maps.newHashMap();

    public @Nullable CustomBossEvent get(Identifier var0) {
        return this.events.get(var0);
    }

    public CustomBossEvent create(Identifier var0, Component var1) {
        CustomBossEvent var2 = new CustomBossEvent(var0, var1);
        this.events.put(var0, var2);
        return var2;
    }

    public void remove(CustomBossEvent var0) {
        this.events.remove(var0.getTextId());
    }

    public Collection<Identifier> getIds() {
        return this.events.keySet();
    }

    public Collection<CustomBossEvent> getEvents() {
        return this.events.values();
    }

    public CompoundTag save(HolderLookup.Provider var0) {
        Map<Identifier, CustomBossEvent.Packed> var1 = Util.mapValues(this.events, CustomBossEvent::pack);
        return (CompoundTag)EVENTS_CODEC.encodeStart(var0.createSerializationContext(NbtOps.INSTANCE), var1).getOrThrow();
    }

    public void load(CompoundTag var02, HolderLookup.Provider var12) {
        Map<Identifier, CustomBossEvent.Packed> var2 = EVENTS_CODEC.parse(var12.createSerializationContext(NbtOps.INSTANCE), (Object)var02).resultOrPartial(var0 -> LOGGER.error("Failed to parse boss bar events: {}", var0)).orElse(Map.of());
        var2.forEach((var0, var1) -> this.events.put((Identifier)var0, CustomBossEvent.load(var0, var1)));
    }

    public void onPlayerConnect(ServerPlayer var0) {
        for (CustomBossEvent var2 : this.events.values()) {
            var2.onPlayerConnect(var0);
        }
    }

    public void onPlayerDisconnect(ServerPlayer var0) {
        for (CustomBossEvent var2 : this.events.values()) {
            var2.onPlayerDisconnect(var0);
        }
    }
}

