/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jspecify.annotations.Nullable;

public class DebugConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var12) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("debugconfig").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(Commands.literal("config").then(Commands.argument("target", EntityArgument.player()).executes(var0 -> DebugConfigCommand.config((CommandSourceStack)var0.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)var0, "target")))))).then(Commands.literal("unconfig").then(Commands.argument("target", UuidArgument.uuid()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandSourceStack)var0.getSource()).getServer()), var1)).executes(var0 -> DebugConfigCommand.unconfig((CommandSourceStack)var0.getSource(), UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "target")))))).then(Commands.literal("dialog").then(Commands.argument("target", UuidArgument.uuid()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandSourceStack)var0.getSource()).getServer()), var1)).then(Commands.argument("dialog", ResourceOrIdArgument.dialog(var12)).executes(var0 -> DebugConfigCommand.showDialog((CommandSourceStack)var0.getSource(), UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "target"), ResourceOrIdArgument.getDialog((CommandContext<CommandSourceStack>)var0, "dialog"))))))));
    }

    private static Iterable<String> getUuidsInConfig(MinecraftServer var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (Connection var3 : var0.getConnection().getConnections()) {
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) continue;
            ServerConfigurationPacketListenerImpl var4 = (ServerConfigurationPacketListenerImpl)packetListener;
            var1.add(var4.getOwner().id().toString());
        }
        return var1;
    }

    private static int config(CommandSourceStack var0, ServerPlayer var1) {
        GameProfile var2 = var1.getGameProfile();
        var1.connection.switchToConfig();
        var0.sendSuccess(() -> Component.literal("Switched player " + var2.name() + "(" + String.valueOf(var2.id()) + ") to config mode"), false);
        return 1;
    }

    private static @Nullable ServerConfigurationPacketListenerImpl findConfigPlayer(MinecraftServer var0, UUID var1) {
        for (Connection var3 : var0.getConnection().getConnections()) {
            ServerConfigurationPacketListenerImpl var4;
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl) || !(var4 = (ServerConfigurationPacketListenerImpl)packetListener).getOwner().id().equals(var1)) continue;
            return var4;
        }
        return null;
    }

    private static int unconfig(CommandSourceStack var0, UUID var1) {
        ServerConfigurationPacketListenerImpl var2 = DebugConfigCommand.findConfigPlayer(var0.getServer(), var1);
        if (var2 != null) {
            var2.returnToWorld();
            return 1;
        }
        var0.sendFailure(Component.literal("Can't find player to unconfig"));
        return 0;
    }

    private static int showDialog(CommandSourceStack var0, UUID var1, Holder<Dialog> var2) {
        ServerConfigurationPacketListenerImpl var3 = DebugConfigCommand.findConfigPlayer(var0.getServer(), var1);
        if (var3 != null) {
            var3.send(new ClientboundShowDialogPacket(var2));
            return 1;
        }
        var0.sendFailure(Component.literal("Can't find player to talk to"));
        return 0;
    }
}

