/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType ERROR_VOLUME_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.fillbiome.toobig", var0, var1));

    public static void register(CommandDispatcher<CommandSourceStack> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fillbiome").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("from", BlockPosArgument.blockPos()).then(Commands.argument("to", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("biome", ResourceArgument.resource(var1, Registries.BIOME)).executes(var02 -> FillBiomeCommand.fill((CommandSourceStack)var02.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var02, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var02, "to"), ResourceArgument.getResource((CommandContext<CommandSourceStack>)var02, "biome", Registries.BIOME), var0 -> true))).then(Commands.literal("replace").then(Commands.argument("filter", ResourceOrTagArgument.resourceOrTag(var1, Registries.BIOME)).executes(var0 -> FillBiomeCommand.fill((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "to"), ResourceArgument.getResource((CommandContext<CommandSourceStack>)var0, "biome", Registries.BIOME), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandSourceStack>)var0, "filter", Registries.BIOME))))))))));
    }

    private static int quantize(int var0) {
        return QuartPos.toBlock(QuartPos.fromBlock(var0));
    }

    private static BlockPos quantize(BlockPos var0) {
        return new BlockPos(FillBiomeCommand.quantize(var0.getX()), FillBiomeCommand.quantize(var0.getY()), FillBiomeCommand.quantize(var0.getZ()));
    }

    private static BiomeResolver makeResolver(MutableInt var0, ChunkAccess var1, BoundingBox var2, Holder<Biome> var3, Predicate<Holder<Biome>> var4) {
        return (var5, var6, var7, var8) -> {
            int var9 = QuartPos.toBlock(var5);
            int var10 = QuartPos.toBlock(var6);
            int var11 = QuartPos.toBlock(var7);
            Holder<Biome> var12 = var1.getNoiseBiome(var5, var6, var7);
            if (var2.isInside(var9, var10, var11) && var4.test(var12)) {
                var0.increment();
                return var3;
            }
            return var12;
        };
    }

    public static Either<Integer, CommandSyntaxException> fill(ServerLevel var02, BlockPos var1, BlockPos var2, Holder<Biome> var3) {
        return FillBiomeCommand.fill(var02, var1, var2, var3, var0 -> true, var0 -> {});
    }

    public static Either<Integer, CommandSyntaxException> fill(ServerLevel var0, BlockPos var1, BlockPos var2, Holder<Biome> var3, Predicate<Holder<Biome>> var4, Consumer<Supplier<Component>> var5) {
        int var10;
        BlockPos var7;
        BlockPos var6 = FillBiomeCommand.quantize(var1);
        BoundingBox var8 = BoundingBox.fromCorners(var6, var7 = FillBiomeCommand.quantize(var2));
        int var9 = var8.getXSpan() * var8.getYSpan() * var8.getZSpan();
        if (var9 > (var10 = var0.getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS).intValue())) {
            return Either.right((Object)((Object)ERROR_VOLUME_TOO_LARGE.create((Object)var10, (Object)var9)));
        }
        ArrayList<ChunkAccess> var11 = new ArrayList<ChunkAccess>();
        for (int var12 = SectionPos.blockToSectionCoord(var8.minZ()); var12 <= SectionPos.blockToSectionCoord(var8.maxZ()); ++var12) {
            for (int var13 = SectionPos.blockToSectionCoord(var8.minX()); var13 <= SectionPos.blockToSectionCoord(var8.maxX()); ++var13) {
                ChunkAccess var14 = var0.getChunk(var13, var12, ChunkStatus.FULL, false);
                if (var14 == null) {
                    return Either.right((Object)((Object)ERROR_NOT_LOADED.create()));
                }
                var11.add(var14);
            }
        }
        MutableInt var12 = new MutableInt(0);
        for (ChunkAccess var14 : var11) {
            var14.fillBiomesFromNoise(FillBiomeCommand.makeResolver(var12, var14, var8, var3, var4), var0.getChunkSource().randomState().sampler());
            var14.markUnsaved();
        }
        var0.getChunkSource().chunkMap.resendBiomesForChunks(var11);
        var5.accept(() -> Component.translatable("commands.fillbiome.success.count", var12.intValue(), var8.minX(), var8.minY(), var8.minZ(), var8.maxX(), var8.maxY(), var8.maxZ()));
        return Either.left((Object)var12.intValue());
    }

    private static int fill(CommandSourceStack var0, BlockPos var12, BlockPos var2, Holder.Reference<Biome> var3, Predicate<Holder<Biome>> var4) throws CommandSyntaxException {
        Either<Integer, CommandSyntaxException> var5 = FillBiomeCommand.fill(var0.getLevel(), var12, var2, var3, var4, var1 -> var0.sendSuccess((Supplier<Component>)var1, true));
        Optional var6 = var5.right();
        if (var6.isPresent()) {
            throw (CommandSyntaxException)((Object)var6.get());
        }
        return (Integer)var5.left().get();
    }
}

