/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.Identifier;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import org.jspecify.annotations.Nullable;

public class FunctionCommand {
    private static final DynamicCommandExceptionType ERROR_ARGUMENT_NOT_COMPOUND = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.function.error.argument_not_compound", var0));
    static final DynamicCommandExceptionType ERROR_NO_FUNCTIONS = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.function.scheduled.no_functions", var0));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.function.instantiationFailure", var0, var1));
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_FUNCTION = (var0, var1) -> {
        ServerFunctionManager var2 = ((CommandSourceStack)var0.getSource()).getServer().getFunctions();
        SharedSuggestionProvider.suggestResource(var2.getTagNames(), var1, "#");
        return SharedSuggestionProvider.suggestResource(var2.getFunctionNames(), var1);
    };
    static final Callbacks<CommandSourceStack> FULL_CONTEXT_CALLBACKS = new Callbacks<CommandSourceStack>(){

        @Override
        public void signalResult(CommandSourceStack var0, Identifier var1, int var2) {
            var0.sendSuccess(() -> Component.translatable("commands.function.result", Component.translationArg(var1), var2), true);
        }
    };

    public static void register(CommandDispatcher<CommandSourceStack> var0) {
        LiteralArgumentBuilder<CommandSourceStack> var12 = Commands.literal("with");
        for (final DataCommands.DataProvider var3 : DataCommands.SOURCE_PROVIDERS) {
            var3.wrap((ArgumentBuilder<CommandSourceStack, ?>)var12, var1 -> var1.executes((Command)new FunctionCustomExecutor(){

                @Override
                protected CompoundTag arguments(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                    return var3.access(var0).getData();
                }
            }).then(Commands.argument("path", NbtPathArgument.nbtPath()).executes((Command)new FunctionCustomExecutor(){

                @Override
                protected CompoundTag arguments(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                    return FunctionCommand.getArgumentTag(NbtPathArgument.getPath(var0, "path"), var3.access(var0));
                }
            })));
        }
        var0.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("function").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("name", FunctionArgument.functions()).suggests(SUGGEST_FUNCTION).executes((Command)new FunctionCustomExecutor(){

            @Override
            protected @Nullable CompoundTag arguments(CommandContext<CommandSourceStack> var0) {
                return null;
            }
        })).then(Commands.argument("arguments", CompoundTagArgument.compoundTag()).executes((Command)new FunctionCustomExecutor(){

            @Override
            protected CompoundTag arguments(CommandContext<CommandSourceStack> var0) {
                return CompoundTagArgument.getCompoundTag(var0, "arguments");
            }
        }))).then(var12))));
    }

    static CompoundTag getArgumentTag(NbtPathArgument.NbtPath var0, DataAccessor var1) throws CommandSyntaxException {
        Tag var2 = DataCommands.getSingleTag(var0, var1);
        if (var2 instanceof CompoundTag) {
            CompoundTag var3 = (CompoundTag)var2;
            return var3;
        }
        throw ERROR_ARGUMENT_NOT_COMPOUND.create((Object)var2.getType().getName());
    }

    public static CommandSourceStack modifySenderForExecution(CommandSourceStack var0) {
        return var0.withSuppressedOutput().withMaximumPermission(LevelBasedPermissionSet.GAMEMASTER);
    }

    public static <T extends ExecutionCommandSource<T>> void queueFunctions(Collection<CommandFunction<T>> var0, @Nullable CompoundTag var1, T var2, T var3, ExecutionControl<T> var4, Callbacks<T> var5, ChainModifiers var6) throws CommandSyntaxException {
        if (var6.isReturn()) {
            FunctionCommand.queueFunctionsAsReturn(var0, var1, var2, var3, var4, var5);
        } else {
            FunctionCommand.queueFunctionsNoReturn(var0, var1, var2, var3, var4, var5);
        }
    }

    private static <T extends ExecutionCommandSource<T>> void instantiateAndQueueFunctions(@Nullable CompoundTag var0, ExecutionControl<T> var1, CommandDispatcher<T> var2, T var3, CommandFunction<T> var4, Identifier var5, CommandResultCallback var6, boolean var7) throws CommandSyntaxException {
        try {
            InstantiatedFunction<T> var8 = var4.instantiate(var0, var2);
            var1.queueNext(new CallFunction<T>(var8, var6, var7).bind(var3));
        }
        catch (FunctionInstantiationException var8) {
            throw ERROR_FUNCTION_INSTANTATION_FAILURE.create((Object)var5, (Object)var8.messageComponent());
        }
    }

    private static <T extends ExecutionCommandSource<T>> CommandResultCallback decorateOutputIfNeeded(T var0, Callbacks<T> var1, Identifier var2, CommandResultCallback var3) {
        if (var0.isSilent()) {
            return var3;
        }
        return (var4, var5) -> {
            var1.signalResult(var0, var2, var5);
            var3.onResult(var4, var5);
        };
    }

    private static <T extends ExecutionCommandSource<T>> void queueFunctionsAsReturn(Collection<CommandFunction<T>> var0, @Nullable CompoundTag var1, T var2, T var3, ExecutionControl<T> var4, Callbacks<T> var5) throws CommandSyntaxException {
        CommandDispatcher<T> var6 = var2.dispatcher();
        T var7 = var3.clearCallbacks();
        CommandResultCallback var8 = CommandResultCallback.chain(var2.callback(), var4.currentFrame().returnValueConsumer());
        for (CommandFunction<T> var10 : var0) {
            Identifier var11 = var10.id();
            CommandResultCallback var12 = FunctionCommand.decorateOutputIfNeeded(var2, var5, var11, var8);
            FunctionCommand.instantiateAndQueueFunctions(var1, var4, var6, var7, var10, var11, var12, true);
        }
        var4.queueNext(FallthroughTask.instance());
    }

    private static <T extends ExecutionCommandSource<T>> void queueFunctionsNoReturn(Collection<CommandFunction<T>> var0, @Nullable CompoundTag var12, T var22, T var32, ExecutionControl<T> var4, Callbacks<T> var5) throws CommandSyntaxException {
        CommandDispatcher<T> var6 = var22.dispatcher();
        T var7 = var32.clearCallbacks();
        CommandResultCallback var8 = var22.callback();
        if (var0.isEmpty()) {
            return;
        }
        if (var0.size() == 1) {
            CommandFunction<T> var9 = var0.iterator().next();
            Identifier var10 = var9.id();
            CommandResultCallback var11 = FunctionCommand.decorateOutputIfNeeded(var22, var5, var10, var8);
            FunctionCommand.instantiateAndQueueFunctions(var12, var4, var6, var7, var9, var10, var11, false);
        } else if (var8 == CommandResultCallback.EMPTY) {
            for (CommandFunction<T> var10 : var0) {
                Identifier var11 = var10.id();
                CommandResultCallback var122 = FunctionCommand.decorateOutputIfNeeded(var22, var5, var11, var8);
                FunctionCommand.instantiateAndQueueFunctions(var12, var4, var6, var7, var10, var11, var122, false);
            }
        } else {
            class Accumulator {
                boolean anyResult;
                int sum;

                Accumulator() {
                }

                public void add(int var0) {
                    this.anyResult = true;
                    this.sum += var0;
                }
            }
            Accumulator var9 = new Accumulator();
            CommandResultCallback var10 = (var1, var2) -> var9.add(var2);
            for (CommandFunction<T> var123 : var0) {
                Identifier var13 = var123.id();
                CommandResultCallback var14 = FunctionCommand.decorateOutputIfNeeded(var22, var5, var13, var10);
                FunctionCommand.instantiateAndQueueFunctions(var12, var4, var6, var7, var123, var13, var14, false);
            }
            var4.queueNext((var2, var3) -> {
                if (var0.anyResult) {
                    var8.onSuccess(var0.sum);
                }
            });
        }
    }

    public static interface Callbacks<T> {
        public void signalResult(T var1, Identifier var2, int var3);
    }

    static abstract class FunctionCustomExecutor
    extends CustomCommandExecutor.WithErrorHandling<CommandSourceStack>
    implements CustomCommandExecutor.CommandAdapter<CommandSourceStack> {
        FunctionCustomExecutor() {
        }

        protected abstract @Nullable CompoundTag arguments(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        @Override
        public void runGuarded(CommandSourceStack var0, ContextChain<CommandSourceStack> var1, ChainModifiers var2, ExecutionControl<CommandSourceStack> var3) throws CommandSyntaxException {
            CommandContext var4 = var1.getTopContext().copyFor((Object)var0);
            Pair<Identifier, Collection<CommandFunction<CommandSourceStack>>> var5 = FunctionArgument.getFunctionCollection((CommandContext<CommandSourceStack>)var4, "name");
            Collection var6 = (Collection)var5.getSecond();
            if (var6.isEmpty()) {
                throw ERROR_NO_FUNCTIONS.create((Object)Component.translationArg((Identifier)var5.getFirst()));
            }
            CompoundTag var7 = this.arguments((CommandContext<CommandSourceStack>)var4);
            CommandSourceStack var8 = FunctionCommand.modifySenderForExecution(var0);
            if (var6.size() == 1) {
                var0.sendSuccess(() -> Component.translatable("commands.function.scheduled.single", Component.translationArg(((CommandFunction)var6.iterator().next()).id())), true);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.function.scheduled.multiple", ComponentUtils.formatList(var6.stream().map(CommandFunction::id).toList(), Component::translationArg)), true);
            }
            FunctionCommand.queueFunctions(var6, var7, var0, var8, var3, FULL_CONTEXT_CALLBACKS, var2);
        }

        @Override
        public /* synthetic */ void runGuarded(ExecutionCommandSource executionCommandSource, ContextChain contextChain, ChainModifiers chainModifiers, ExecutionControl executionControl) throws CommandSyntaxException {
            this.runGuarded((CommandSourceStack)executionCommandSource, (ContextChain<CommandSourceStack>)contextChain, chainModifiers, (ExecutionControl<CommandSourceStack>)executionControl);
        }
    }
}

