/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import net.minecraft.world.level.gamerules.GameRules;

public class GameRuleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher, CommandBuildContext commandbuildcontext) {
        final LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal("gamerule").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS));
        new GameRules(commandbuildcontext.enabledFeatures()).visitGameRuleTypes(new GameRuleTypeVisitor(){

            @Override
            public <T> void visit(GameRule<T> gamerule) {
                LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder1 = Commands.literal(gamerule.id());
                LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder2 = Commands.literal(gamerule.getIdentifier().toString());
                ((LiteralArgumentBuilder)literalargumentbuilder.then(GameRuleCommand.buildRuleArguments(gamerule, literalargumentbuilder1))).then(GameRuleCommand.buildRuleArguments(gamerule, literalargumentbuilder2));
            }
        });
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalargumentbuilder);
    }

    static <T> LiteralArgumentBuilder<CommandSourceStack> buildRuleArguments(GameRule<T> gamerule, LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.executes(commandcontext -> GameRuleCommand.queryRule((CommandSourceStack)commandcontext.getSource(), gamerule))).then(Commands.argument("value", gamerule.argument()).executes(commandcontext -> GameRuleCommand.setRule((CommandContext<CommandSourceStack>)commandcontext, gamerule)));
    }

    private static <T> int setRule(CommandContext<CommandSourceStack> commandcontext, GameRule<T> gamerule) {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        Object t0 = commandcontext.getArgument("value", gamerule.valueClass());
        commandlistenerwrapper.getLevel().getGameRules().set(gamerule, t0, ((CommandSourceStack)commandcontext.getSource()).getLevel());
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.gamerule.set", gamerule.id(), gamerule.serialize(t0)), true);
        return gamerule.getCommandResult(t0);
    }

    private static <T> int queryRule(CommandSourceStack commandlistenerwrapper, GameRule<T> gamerule) {
        Object t0 = commandlistenerwrapper.getLevel().getGameRules().get(gamerule);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.gamerule.query", gamerule.id(), gamerule.serialize(t0)), false);
        return gamerule.getCommandResult(t0);
    }
}

