/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;

public class JfrCommand {
    private static final SimpleCommandExceptionType START_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.jfr.start.failed"));
    private static final DynamicCommandExceptionType DUMP_FAILED = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.jfr.dump.failed", var0));

    private JfrCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("jfr").requires(Commands.hasPermission(Commands.LEVEL_OWNERS))).then(Commands.literal("start").executes(var0 -> JfrCommand.startJfr((CommandSourceStack)var0.getSource())))).then(Commands.literal("stop").executes(var0 -> JfrCommand.stopJfr((CommandSourceStack)var0.getSource())))));
    }

    private static int startJfr(CommandSourceStack var0) throws CommandSyntaxException {
        Environment var1 = Environment.from(var0.getServer());
        if (!JvmProfiler.INSTANCE.start(var1)) {
            throw START_FAILED.create();
        }
        var0.sendSuccess(() -> Component.translatable("commands.jfr.started"), false);
        return 1;
    }

    private static int stopJfr(CommandSourceStack var0) throws CommandSyntaxException {
        try {
            Path var12 = Paths.get(".", new String[0]).relativize(JvmProfiler.INSTANCE.stop().normalize());
            Path var2 = !var0.getServer().isPublished() || SharedConstants.IS_RUNNING_IN_IDE ? var12.toAbsolutePath() : var12;
            MutableComponent var3 = Component.literal(var12.toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(var1 -> var1.withClickEvent(new ClickEvent.CopyToClipboard(var2.toString())).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.copy.click"))));
            var0.sendSuccess(() -> Component.translatable("commands.jfr.stopped", var3), false);
            return 1;
        }
        catch (Throwable var13) {
            throw DUMP_FAILED.create((Object)var13.getMessage());
        }
    }
}

