/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootCommand {
    private static final DynamicCommandExceptionType ERROR_NO_HELD_ITEMS = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType ERROR_NO_ENTITY_LOOT_TABLE = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.drop.no_loot_table.entity", object));
    private static final DynamicCommandExceptionType ERROR_NO_BLOCK_LOOT_TABLE = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.drop.no_loot_table.block", object));

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)LootCommand.addTargets((LiteralArgumentBuilder)Commands.literal("loot").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS)), (argumentbuilder, commandloot_b) -> argumentbuilder.then(Commands.literal("fish").then(Commands.argument("loot_table", ResourceOrIdArgument.lootTable(commandbuildcontext)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(Commands.argument("tool", ItemArgument.item(commandbuildcontext)).executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemArgument.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(Commands.literal("mainhand").executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.MAINHAND), commandloot_b)))).then(Commands.literal("offhand").executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.OFFHAND), commandloot_b)))))).then(Commands.literal("loot").then(Commands.argument("loot_table", ResourceOrIdArgument.lootTable(commandbuildcontext)).executes(commandcontext -> LootCommand.dropChestLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), commandloot_b)))).then(Commands.literal("kill").then(Commands.argument("target", EntityArgument.entity()).executes(commandcontext -> LootCommand.dropKillLoot((CommandContext<CommandSourceStack>)commandcontext, EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "target"), commandloot_b)))).then(Commands.literal("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(Commands.argument("tool", ItemArgument.item(commandbuildcontext)).executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemArgument.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(Commands.literal("mainhand").executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.MAINHAND), commandloot_b)))).then(Commands.literal("offhand").executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.OFFHAND), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandSourceStack, T>> T addTargets(T t0, TailProvider commandloot_c) {
        return (T)t0.then(((LiteralArgumentBuilder)Commands.literal("replace").then(Commands.literal("entity").then(Commands.argument("entities", EntityArgument.entities()).then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("slot", SlotArgument.slot()), (commandcontext, list, commandloot_a) -> LootCommand.entityReplace(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "entities"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> LootCommand.entityReplace(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "entities"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(Commands.literal("block").then(Commands.argument("targetPos", BlockPosArgument.blockPos()).then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("slot", SlotArgument.slot()), (commandcontext, list, commandloot_a) -> LootCommand.blockReplace((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> LootCommand.blockReplace((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(Commands.literal("insert").then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("targetPos", BlockPosArgument.blockPos()), (commandcontext, list, commandloot_a) -> LootCommand.blockDistribute((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), list, commandloot_a)))).then(Commands.literal("give").then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("players", EntityArgument.players()), (commandcontext, list, commandloot_a) -> LootCommand.playerGive(EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "players"), list, commandloot_a)))).then(Commands.literal("spawn").then(commandloot_c.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("targetPos", Vec3Argument.vec3()), (commandcontext, list, commandloot_a) -> LootCommand.dropInWorld((CommandSourceStack)commandcontext.getSource(), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), list, commandloot_a))));
    }

    private static Container getContainer(CommandSourceStack commandlistenerwrapper, BlockPos blockposition) throws CommandSyntaxException {
        BlockEntity tileentity = commandlistenerwrapper.getLevel().getBlockEntity(blockposition);
        if (!(tileentity instanceof Container)) {
            throw ItemCommands.ERROR_TARGET_NOT_A_CONTAINER.create((Object)blockposition.getX(), (Object)blockposition.getY(), (Object)blockposition.getZ());
        }
        return (Container)((Object)tileentity);
    }

    private static int blockDistribute(CommandSourceStack commandlistenerwrapper, BlockPos blockposition, List<ItemStack> list, Callback commandloot_a) throws CommandSyntaxException {
        Container iinventory = LootCommand.getContainer(commandlistenerwrapper, blockposition);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            if (!LootCommand.distributeToContainer(iinventory, itemstack.copy())) continue;
            iinventory.setChanged();
            list1.add(itemstack);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static boolean distributeToContainer(Container iinventory, ItemStack itemstack) {
        boolean flag = false;
        for (int i = 0; i < iinventory.getContainerSize() && !itemstack.isEmpty(); ++i) {
            ItemStack itemstack1 = iinventory.getItem(i);
            if (!iinventory.canPlaceItem(i, itemstack)) continue;
            if (itemstack1.isEmpty()) {
                iinventory.setItem(i, itemstack);
                flag = true;
                break;
            }
            if (!LootCommand.canMergeItems(itemstack1, itemstack)) continue;
            int j = itemstack.getMaxStackSize() - itemstack1.getCount();
            int k = Math.min(itemstack.getCount(), j);
            itemstack.shrink(k);
            itemstack1.grow(k);
            flag = true;
        }
        return flag;
    }

    private static int blockReplace(CommandSourceStack commandlistenerwrapper, BlockPos blockposition, int i, int j, List<ItemStack> list, Callback commandloot_a) throws CommandSyntaxException {
        Container iinventory = LootCommand.getContainer(commandlistenerwrapper, blockposition);
        int k = iinventory.getContainerSize();
        if (i >= 0 && i < k) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
            for (int l = 0; l < j; ++l) {
                ItemStack itemstack;
                int i1 = i + l;
                ItemStack itemStack = itemstack = l < list.size() ? list.get(l) : ItemStack.EMPTY;
                if (!iinventory.canPlaceItem(i1, itemstack)) continue;
                iinventory.setItem(i1, itemstack);
                list1.add(itemstack);
            }
            commandloot_a.accept(list1);
            return list1.size();
        }
        throw ItemCommands.ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)i);
    }

    private static boolean canMergeItems(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.getCount() <= itemstack.getMaxStackSize() && ItemStack.isSameItemSameComponents(itemstack, itemstack1);
    }

    private static int playerGive(Collection<ServerPlayer> collection, List<ItemStack> list, Callback commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            for (ServerPlayer entityplayer : collection) {
                if (!entityplayer.getInventory().add(itemstack.copy())) continue;
                list1.add(itemstack);
            }
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static void setSlots(Entity entity, List<ItemStack> list, int i, int j, List<ItemStack> list1) {
        for (int k = 0; k < j; ++k) {
            ItemStack itemstack = k < list.size() ? list.get(k) : ItemStack.EMPTY;
            SlotAccess slotaccess = entity.getSlot(i + k);
            if (slotaccess == null || !slotaccess.set(itemstack.copy())) continue;
            list1.add(itemstack);
        }
    }

    private static int entityReplace(Collection<? extends Entity> collection, int i, int j, List<ItemStack> list, Callback commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (Entity entity : collection) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                LootCommand.setSlots(entity, list, i, j, list1);
                entityplayer.containerMenu.broadcastChanges();
                continue;
            }
            LootCommand.setSlots(entity, list, i, j, list1);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static int dropInWorld(CommandSourceStack commandlistenerwrapper, Vec3 vec3d, List<ItemStack> list, Callback commandloot_a) throws CommandSyntaxException {
        ServerLevel worldserver = commandlistenerwrapper.getLevel();
        list.removeIf(ItemStack::isEmpty);
        list.forEach(itemstack -> {
            ItemEntity entityitem = new ItemEntity(worldserver, vec3d.x, vec3d.y, vec3d.z, itemstack.copy());
            entityitem.setDefaultPickUpDelay();
            worldserver.addFreshEntity(entityitem);
        });
        commandloot_a.accept(list);
        return list.size();
    }

    private static void callback(CommandSourceStack commandlistenerwrapper, List<ItemStack> list) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.drop.success.single", itemstack.getCount(), itemstack.getDisplayName()), false);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.drop.success.multiple", list.size()), false);
        }
    }

    private static void callback(CommandSourceStack commandlistenerwrapper, List<ItemStack> list, ResourceKey<LootTable> resourcekey) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.drop.success.single_with_table", itemstack.getCount(), itemstack.getDisplayName(), Component.translationArg(resourcekey.identifier())), false);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.drop.success.multiple_with_table", list.size(), Component.translationArg(resourcekey.identifier())), false);
        }
    }

    private static ItemStack getSourceHandItem(CommandSourceStack commandlistenerwrapper, EquipmentSlot enumitemslot) throws CommandSyntaxException {
        Entity entity = commandlistenerwrapper.getEntityOrException();
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getItemBySlot(enumitemslot);
        }
        throw ERROR_NO_HELD_ITEMS.create((Object)entity.getDisplayName());
    }

    private static int dropBlockLoot(CommandContext<CommandSourceStack> commandcontext, BlockPos blockposition, ItemStack itemstack, DropConsumer commandloot_b) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        ServerLevel worldserver = commandlistenerwrapper.getLevel();
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
        Optional<ResourceKey<LootTable>> optional = iblockdata.getBlock().getLootTable();
        if (optional.isEmpty()) {
            throw ERROR_NO_BLOCK_LOOT_TABLE.create((Object)iblockdata.getBlock().getName());
        }
        LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.BLOCK_STATE, iblockdata).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParams.TOOL, itemstack);
        List<ItemStack> list = iblockdata.getDrops(lootparams_a);
        return commandloot_b.accept(commandcontext, list, list1 -> LootCommand.callback(commandlistenerwrapper, list1, (ResourceKey)optional.get()));
    }

    private static int dropKillLoot(CommandContext<CommandSourceStack> commandcontext, Entity entity, DropConsumer commandloot_b) throws CommandSyntaxException {
        Optional<ResourceKey<LootTable>> optional = entity.getLootTable();
        if (optional.isEmpty()) {
            throw ERROR_NO_ENTITY_LOOT_TABLE.create((Object)entity.getDisplayName());
        }
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        LootParams.Builder lootparams_a = new LootParams.Builder(commandlistenerwrapper.getLevel());
        Entity entity1 = commandlistenerwrapper.getEntity();
        if (entity1 instanceof Player) {
            Player entityhuman = (Player)entity1;
            lootparams_a.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, entityhuman);
        }
        lootparams_a.withParameter(LootContextParams.DAMAGE_SOURCE, entity.damageSources().magic());
        lootparams_a.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, entity1);
        lootparams_a.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, entity1);
        lootparams_a.withParameter(LootContextParams.THIS_ENTITY, entity);
        lootparams_a.withParameter(LootContextParams.ORIGIN, commandlistenerwrapper.getPosition());
        LootParams lootparams = lootparams_a.create(LootContextParamSets.ENTITY);
        LootTable loottable = commandlistenerwrapper.getServer().reloadableRegistries().getLootTable(optional.get());
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> LootCommand.callback(commandlistenerwrapper, list1, (ResourceKey)optional.get()));
    }

    private static int dropChestLoot(CommandContext<CommandSourceStack> commandcontext, Holder<LootTable> holder, DropConsumer commandloot_b) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        LootParams lootparams = new LootParams.Builder(commandlistenerwrapper.getLevel()).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParams.ORIGIN, commandlistenerwrapper.getPosition()).create(LootContextParamSets.CHEST);
        return LootCommand.drop(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int dropFishingLoot(CommandContext<CommandSourceStack> commandcontext, Holder<LootTable> holder, BlockPos blockposition, ItemStack itemstack, DropConsumer commandloot_b) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        LootParams lootparams = new LootParams.Builder(commandlistenerwrapper.getLevel()).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withParameter(LootContextParams.TOOL, itemstack).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).create(LootContextParamSets.FISHING);
        return LootCommand.drop(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int drop(CommandContext<CommandSourceStack> commandcontext, Holder<LootTable> holder, LootParams lootparams, DropConsumer commandloot_b) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
        ObjectArrayList<ItemStack> list = holder.value().getRandomItems(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> LootCommand.callback(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface TailProvider {
        public ArgumentBuilder<CommandSourceStack, ?> construct(ArgumentBuilder<CommandSourceStack, ?> var1, DropConsumer var2);
    }

    @FunctionalInterface
    private static interface DropConsumer {
        public int accept(CommandContext<CommandSourceStack> var1, List<ItemStack> var2, Callback var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface Callback {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

