/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanList;

public class PardonCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.pardon.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pardon").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getBans().getUserList(), var1)).executes(var0 -> PardonCommand.pardonPlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets"))))));
    }

    private static int pardonPlayers(CommandSourceStack var0, Collection<NameAndId> var1) throws CommandSyntaxException {
        UserBanList var2 = var0.getServer().getPlayerList().getBans();
        int var3 = 0;
        for (NameAndId var5 : var1) {
            if (!var2.isBanned(var5)) continue;
            var2.remove(var5);
            ++var3;
            var0.sendSuccess(() -> Component.translatable("commands.pardon.success", Component.literal(var5.name())), true);
        }
        if (var3 == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return var3;
    }
}

