/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeCommand {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.recipe.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.recipe.take.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("recipe").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("give").then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.argument("recipe", ResourceKeyArgument.key(Registries.RECIPE)).executes(var0 -> RecipeCommand.giveRecipes((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Collections.singleton(ResourceKeyArgument.getRecipe((CommandContext<CommandSourceStack>)var0, "recipe")))))).then(Commands.literal("*").executes(var0 -> RecipeCommand.giveRecipes((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ((CommandSourceStack)var0.getSource()).getServer().getRecipeManager().getRecipes())))))).then(Commands.literal("take").then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.argument("recipe", ResourceKeyArgument.key(Registries.RECIPE)).executes(var0 -> RecipeCommand.takeRecipes((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Collections.singleton(ResourceKeyArgument.getRecipe((CommandContext<CommandSourceStack>)var0, "recipe")))))).then(Commands.literal("*").executes(var0 -> RecipeCommand.takeRecipes((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ((CommandSourceStack)var0.getSource()).getServer().getRecipeManager().getRecipes())))))));
    }

    private static int giveRecipes(CommandSourceStack var0, Collection<ServerPlayer> var1, Collection<RecipeHolder<?>> var2) throws CommandSyntaxException {
        int var3 = 0;
        for (ServerPlayer var5 : var1) {
            var3 += var5.awardRecipes(var2);
        }
        if (var3 == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.recipe.give.success.single", var2.size(), ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.recipe.give.success.multiple", var2.size(), var1.size()), true);
        }
        return var3;
    }

    private static int takeRecipes(CommandSourceStack var0, Collection<ServerPlayer> var1, Collection<RecipeHolder<?>> var2) throws CommandSyntaxException {
        int var3 = 0;
        for (ServerPlayer var5 : var1) {
            var3 += var5.resetRecipes(var2);
        }
        if (var3 == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.recipe.take.success.single", var2.size(), ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.recipe.take.success.multiple", var2.size(), var1.size()), true);
        }
        return var3;
    }
}

