/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import java.util.List;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.execution.tasks.FallthroughTask;

public class ReturnCommand {
    public static <T extends ExecutionCommandSource<T>> void register(CommandDispatcher<T> var0) {
        var0.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"return").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(RequiredArgumentBuilder.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(new ReturnValueCustomExecutor()))).then(LiteralArgumentBuilder.literal((String)"fail").executes(new ReturnFailCustomExecutor()))).then(LiteralArgumentBuilder.literal((String)"run").forward(var0.getRoot(), new ReturnFromCommandCustomModifier(), false)));
    }

    static class ReturnValueCustomExecutor<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor.CommandAdapter<T> {
        ReturnValueCustomExecutor() {
        }

        @Override
        public void run(T var0, ContextChain<T> var1, ChainModifiers var2, ExecutionControl<T> var3) {
            int var4 = IntegerArgumentType.getInteger((CommandContext)var1.getTopContext(), (String)"value");
            var0.callback().onSuccess(var4);
            Frame var5 = var3.currentFrame();
            var5.returnSuccess(var4);
            var5.discard();
        }
    }

    static class ReturnFailCustomExecutor<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor.CommandAdapter<T> {
        ReturnFailCustomExecutor() {
        }

        @Override
        public void run(T var0, ContextChain<T> var1, ChainModifiers var2, ExecutionControl<T> var3) {
            var0.callback().onFailure();
            Frame var4 = var3.currentFrame();
            var4.returnFailure();
            var4.discard();
        }
    }

    static class ReturnFromCommandCustomModifier<T extends ExecutionCommandSource<T>>
    implements CustomModifierExecutor.ModifierAdapter<T> {
        ReturnFromCommandCustomModifier() {
        }

        @Override
        public void apply(T var0, List<T> var1, ContextChain<T> var2, ChainModifiers var3, ExecutionControl<T> var4) {
            if (var1.isEmpty()) {
                if (var3.isReturn()) {
                    var4.queueNext(FallthroughTask.instance());
                }
                return;
            }
            var4.currentFrame().discard();
            ContextChain var5 = var2.nextStage();
            String var6 = var5.getTopContext().getInput();
            var4.queueNext(new BuildContexts.Continuation<T>(var6, var5, var3.setReturn(), var0, var1));
        }
    }
}

