/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.MacroFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.world.level.timers.FunctionCallback;
import net.minecraft.world.level.timers.FunctionTagCallback;
import net.minecraft.world.level.timers.TimerQueue;

public class ScheduleCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_TICK = new SimpleCommandExceptionType((Message)Component.translatable("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.schedule.cleared.failure", object));
    private static final SimpleCommandExceptionType ERROR_MACRO = new SimpleCommandExceptionType((Message)Component.translatableEscape("commands.schedule.macro", new Object[0]));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SCHEDULE = (commandcontext, suggestionsbuilder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)commandcontext.getSource()).getServer().getWorldData().overworldData().getScheduledEvents().getEventsIds(), suggestionsbuilder);

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("schedule").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("function").then(Commands.argument("function", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("time", TimeArgument.time()).executes(commandcontext -> ScheduleCommand.schedule((CommandSourceStack)commandcontext.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))).then(Commands.literal("append").executes(commandcontext -> ScheduleCommand.schedule((CommandSourceStack)commandcontext.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), false)))).then(Commands.literal("replace").executes(commandcontext -> ScheduleCommand.schedule((CommandSourceStack)commandcontext.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))))))).then(Commands.literal("clear").then(Commands.argument("function", StringArgumentType.greedyString()).suggests(SUGGEST_SCHEDULE).executes(commandcontext -> ScheduleCommand.remove((CommandSourceStack)commandcontext.getSource(), StringArgumentType.getString((CommandContext)commandcontext, (String)"function")))))));
    }

    private static int schedule(CommandSourceStack commandlistenerwrapper, Pair<Identifier, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> pair, int i, boolean flag) throws CommandSyntaxException {
        if (i == 0) {
            throw ERROR_SAME_TICK.create();
        }
        long j = commandlistenerwrapper.getLevel().getGameTime() + (long)i;
        Identifier minecraftkey = (Identifier)pair.getFirst();
        TimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = commandlistenerwrapper.getLevel().I.overworldData().getScheduledEvents();
        Optional optional = ((Either)pair.getSecond()).left();
        if (optional.isPresent()) {
            if (optional.get() instanceof MacroFunction) {
                throw ERROR_MACRO.create();
            }
            String s = minecraftkey.toString();
            if (flag) {
                customfunctioncallbacktimerqueue.remove(s);
            }
            customfunctioncallbacktimerqueue.schedule(s, j, new FunctionCallback(minecraftkey));
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.schedule.created.function", Component.translationArg(minecraftkey), i, j), true);
        } else {
            String s1 = "#" + String.valueOf(minecraftkey);
            if (flag) {
                customfunctioncallbacktimerqueue.remove(s1);
            }
            customfunctioncallbacktimerqueue.schedule(s1, j, new FunctionTagCallback(minecraftkey));
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.schedule.created.tag", Component.translationArg(minecraftkey), i, j), true);
        }
        return Math.floorMod(j, Integer.MAX_VALUE);
    }

    private static int remove(CommandSourceStack commandlistenerwrapper, String s) throws CommandSyntaxException {
        int i = commandlistenerwrapper.getServer().getWorldData().overworldData().getScheduledEvents().remove(s);
        if (i == 0) {
            throw ERROR_CANT_REMOVE.create((Object)s);
        }
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.schedule.cleared.success", i, s), true);
        return i;
    }
}

