/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.Nullable;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        LiteralCommandNode<CommandSourceStack> literalcommandnode = commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("location", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getEntityOrException()), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToEntity((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.anchor()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "facingEntity"), EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)commandcontext, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(commandcontext -> TeleportCommand.teleportToPos((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ((CommandSourceStack)commandcontext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandcontext, "location"), null, new LookAt.LookAtPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(commandcontext -> TeleportCommand.teleportToEntity((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "destination")))))));
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).redirect(literalcommandnode)));
    }

    private static int teleportToEntity(CommandSourceStack commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, net.minecraft.world.entity.Entity entity) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity2 : collection) {
            TeleportCommand.performTeleport(commandlistenerwrapper, entity2, (ServerLevel)entity.level(), entity.getX(), entity.getY(), entity.getZ(), EnumSet.noneOf(Relative.class), entity.getYRot(), entity.getXRot(), null);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).getDisplayName(), entity.getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.multiple", collection.size(), entity.getDisplayName()), true);
        }
        return collection.size();
    }

    private static int teleportToPos(CommandSourceStack commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, ServerLevel worldserver, Coordinates ivectorposition, @Nullable Coordinates ivectorposition1, @Nullable LookAt lookat) throws CommandSyntaxException {
        Vec3 vec3d = ivectorposition.getPosition(commandlistenerwrapper);
        Vec2 vec2f = ivectorposition1 == null ? null : ivectorposition1.getRotation(commandlistenerwrapper);
        for (net.minecraft.world.entity.Entity entity : collection) {
            Set<Relative> set = TeleportCommand.getRelatives(ivectorposition, ivectorposition1, entity.level().dimension() == worldserver.dimension());
            if (vec2f == null) {
                TeleportCommand.performTeleport(commandlistenerwrapper, entity, worldserver, vec3d.x, vec3d.y, vec3d.z, set, entity.getYRot(), entity.getXRot(), lookat);
                continue;
            }
            TeleportCommand.performTeleport(commandlistenerwrapper, entity, worldserver, vec3d.x, vec3d.y, vec3d.z, set, vec2f.y, vec2f.x, lookat);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).getDisplayName(), TeleportCommand.formatDouble(vec3d.x), TeleportCommand.formatDouble(vec3d.y), TeleportCommand.formatDouble(vec3d.z)), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.teleport.success.location.multiple", collection.size(), TeleportCommand.formatDouble(vec3d.x), TeleportCommand.formatDouble(vec3d.y), TeleportCommand.formatDouble(vec3d.z)), true);
        }
        return collection.size();
    }

    private static Set<Relative> getRelatives(Coordinates ivectorposition, @Nullable Coordinates ivectorposition1, boolean flag) {
        Set<Relative> set = Relative.direction(ivectorposition.isXRelative(), ivectorposition.isYRelative(), ivectorposition.isZRelative());
        Set set1 = flag ? Relative.position(ivectorposition.isXRelative(), ivectorposition.isYRelative(), ivectorposition.isZRelative()) : Set.of();
        Set<Relative> set2 = ivectorposition1 == null ? Relative.ROTATION : Relative.rotation(ivectorposition1.isYRelative(), ivectorposition1.isXRelative());
        return Relative.union(set, set1, set2);
    }

    private static String formatDouble(double d0) {
        return String.format(Locale.ROOT, "%f", d0);
    }

    private static void performTeleport(CommandSourceStack commandlistenerwrapper, net.minecraft.world.entity.Entity entity, ServerLevel worldserver, double d0, double d1, double d2, Set<Relative> set, float f, float f1, @Nullable LookAt lookat) throws CommandSyntaxException {
        boolean result;
        BlockPos blockposition = BlockPos.containing(d0, d1, d2);
        if (!Level.isInSpawnableBounds(blockposition)) {
            throw INVALID_POSITION.create();
        }
        double d3 = set.contains((Object)Relative.X) ? d0 - entity.getX() : d0;
        double d4 = set.contains((Object)Relative.Y) ? d1 - entity.getY() : d1;
        double d5 = set.contains((Object)Relative.Z) ? d2 - entity.getZ() : d2;
        float f2 = set.contains((Object)Relative.Y_ROT) ? f - entity.getYRot() : f;
        float f3 = set.contains((Object)Relative.X_ROT) ? f1 - entity.getXRot() : f1;
        float f4 = Mth.wrapDegrees(f2);
        float f5 = Mth.wrapDegrees(f3);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            result = player.teleportTo(worldserver, d3, d4, d5, set, f4, f5, true, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((World)worldserver.getWorld(), d3, d4, d5, f4, f5);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), to);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            d3 = to.getX();
            d4 = to.getY();
            d5 = to.getZ();
            f4 = to.getYaw();
            f5 = to.getPitch();
            worldserver = ((CraftWorld)to.getWorld()).getHandle();
            result = entity.teleportTo(worldserver, d3, d4, d5, set, f4, f5, true);
        }
        if (result) {
            LivingEntity entityliving;
            if (lookat != null) {
                lookat.perform(commandlistenerwrapper, entity);
            }
            if (!(entity instanceof LivingEntity) || !(entityliving = (LivingEntity)entity).isFallFlying()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                entity.setOnGround(true);
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob entitycreature = (PathfinderMob)entity;
                entitycreature.getNavigation().stop();
            }
        }
    }
}

