/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.util.TimeUtil;

public class TickCommand {
    private static final float MAX_TICKRATE = 10000.0f;
    private static final String DEFAULT_TICKRATE = String.valueOf(20);

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tick").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(Commands.literal("query").executes(var0 -> TickCommand.tickQuery((CommandSourceStack)var0.getSource())))).then(Commands.literal("rate").then(Commands.argument("rate", FloatArgumentType.floatArg((float)1.0f, (float)10000.0f)).suggests((var0, var1) -> SharedSuggestionProvider.suggest(new String[]{DEFAULT_TICKRATE}, var1)).executes(var0 -> TickCommand.setTickingRate((CommandSourceStack)var0.getSource(), FloatArgumentType.getFloat((CommandContext)var0, (String)"rate")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("step").executes(var0 -> TickCommand.step((CommandSourceStack)var0.getSource(), 1))).then(Commands.literal("stop").executes(var0 -> TickCommand.stopStepping((CommandSourceStack)var0.getSource())))).then(Commands.argument("time", TimeArgument.time(1)).suggests((var0, var1) -> SharedSuggestionProvider.suggest(new String[]{"1t", "1s"}, var1)).executes(var0 -> TickCommand.step((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(((LiteralArgumentBuilder)Commands.literal("sprint").then(Commands.literal("stop").executes(var0 -> TickCommand.stopSprinting((CommandSourceStack)var0.getSource())))).then(Commands.argument("time", TimeArgument.time(1)).suggests((var0, var1) -> SharedSuggestionProvider.suggest(new String[]{"60s", "1d", "3d"}, var1)).executes(var0 -> TickCommand.sprint((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time")))))).then(Commands.literal("unfreeze").executes(var0 -> TickCommand.setFreeze((CommandSourceStack)var0.getSource(), false)))).then(Commands.literal("freeze").executes(var0 -> TickCommand.setFreeze((CommandSourceStack)var0.getSource(), true)))));
    }

    private static String nanosToMilisString(long var0) {
        return String.format(Locale.ROOT, "%.1f", Float.valueOf((float)var0 / (float)TimeUtil.NANOSECONDS_PER_MILLISECOND));
    }

    private static int setTickingRate(CommandSourceStack var0, float var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        var2.setTickRate(var1);
        String var3 = String.format(Locale.ROOT, "%.1f", Float.valueOf(var1));
        var0.sendSuccess(() -> Component.translatable("commands.tick.rate.success", var3), true);
        return (int)var1;
    }

    private static int tickQuery(CommandSourceStack var0) {
        Object var5;
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        String var2 = TickCommand.nanosToMilisString(var0.getServer().getAverageTickTimeNanos());
        float var3 = var1.tickrate();
        String var4 = String.format(Locale.ROOT, "%.1f", Float.valueOf(var3));
        if (var1.isSprinting()) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.status.sprinting"), false);
            var0.sendSuccess(() -> Component.translatable("commands.tick.query.rate.sprinting", var4, var2), false);
        } else {
            if (var1.isFrozen()) {
                var0.sendSuccess(() -> Component.translatable("commands.tick.status.frozen"), false);
            } else if (var1.nanosecondsPerTick() < var0.getServer().getAverageTickTimeNanos()) {
                var0.sendSuccess(() -> Component.translatable("commands.tick.status.lagging"), false);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.tick.status.running"), false);
            }
            var5 = TickCommand.nanosToMilisString(var1.nanosecondsPerTick());
            var0.sendSuccess(() -> TickCommand.lambda$tickQuery$18(var4, var2, (String)var5), false);
        }
        var5 = Arrays.copyOf(var0.getServer().getTickTimesNanos(), var0.getServer().getTickTimesNanos().length);
        Arrays.sort((long[])var5);
        String var6 = TickCommand.nanosToMilisString((long)var5[((Object)var5).length / 2]);
        String var7 = TickCommand.nanosToMilisString((long)var5[(int)((double)((Object)var5).length * 0.95)]);
        String var8 = TickCommand.nanosToMilisString((long)var5[(int)((double)((Object)var5).length * 0.99)]);
        var0.sendSuccess(() -> TickCommand.lambda$tickQuery$19(var6, var7, var8, (long[])var5), false);
        return (int)var3;
    }

    private static int sprint(CommandSourceStack var0, int var1) {
        boolean var2 = var0.getServer().tickRateManager().requestGameToSprint(var1);
        if (var2) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.sprint.stop.success"), true);
        }
        var0.sendSuccess(() -> Component.translatable("commands.tick.status.sprinting"), true);
        return 1;
    }

    private static int setFreeze(CommandSourceStack var0, boolean var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        if (var1) {
            if (var2.isSprinting()) {
                var2.stopSprinting();
            }
            if (var2.isSteppingForward()) {
                var2.stopStepping();
            }
        }
        var2.setFrozen(var1);
        if (var1) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.status.frozen"), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.tick.status.running"), true);
        }
        return var1 ? 1 : 0;
    }

    private static int step(CommandSourceStack var0, int var1) {
        ServerTickRateManager var2 = var0.getServer().tickRateManager();
        boolean var3 = var2.stepGameIfPaused(var1);
        if (var3) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.step.success", var1), true);
        } else {
            var0.sendFailure(Component.translatable("commands.tick.step.fail"));
        }
        return 1;
    }

    private static int stopStepping(CommandSourceStack var0) {
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        boolean var2 = var1.stopStepping();
        if (var2) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.step.stop.success"), true);
            return 1;
        }
        var0.sendFailure(Component.translatable("commands.tick.step.stop.fail"));
        return 0;
    }

    private static int stopSprinting(CommandSourceStack var0) {
        ServerTickRateManager var1 = var0.getServer().tickRateManager();
        boolean var2 = var1.stopSprinting();
        if (var2) {
            var0.sendSuccess(() -> Component.translatable("commands.tick.sprint.stop.success"), true);
            return 1;
        }
        var0.sendFailure(Component.translatable("commands.tick.sprint.stop.fail"));
        return 0;
    }

    private static /* synthetic */ Component lambda$tickQuery$19(String var0, String var1, String var2, long[] var3) {
        return Component.translatable("commands.tick.query.percentiles", var0, var1, var2, var3.length);
    }

    private static /* synthetic */ Component lambda$tickQuery$18(String var0, String var1, String var2) {
        return Component.translatable("commands.tick.query.rate.running", var0, var1, var2);
    }
}

