/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TitleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("title").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("clear").executes(var0 -> TitleCommand.clearTitle((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"))))).then(Commands.literal("reset").executes(var0 -> TitleCommand.resetTitle((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"))))).then(Commands.literal("title").then(Commands.argument("title", ComponentArgument.textComponent(var1)).executes(var0 -> TitleCommand.showTitle((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ComponentArgument.getRawComponent((CommandContext<CommandSourceStack>)var0, "title"), "title", ClientboundSetTitleTextPacket::new))))).then(Commands.literal("subtitle").then(Commands.argument("title", ComponentArgument.textComponent(var1)).executes(var0 -> TitleCommand.showTitle((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ComponentArgument.getRawComponent((CommandContext<CommandSourceStack>)var0, "title"), "subtitle", ClientboundSetSubtitleTextPacket::new))))).then(Commands.literal("actionbar").then(Commands.argument("title", ComponentArgument.textComponent(var1)).executes(var0 -> TitleCommand.showTitle((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ComponentArgument.getRawComponent((CommandContext<CommandSourceStack>)var0, "title"), "actionbar", ClientboundSetActionBarTextPacket::new))))).then(Commands.literal("times").then(Commands.argument("fadeIn", TimeArgument.time()).then(Commands.argument("stay", TimeArgument.time()).then(Commands.argument("fadeOut", TimeArgument.time()).executes(var0 -> TitleCommand.setTimes((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"fadeIn"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"stay"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"fadeOut"))))))))));
    }

    private static int clearTitle(CommandSourceStack var0, Collection<ServerPlayer> var1) {
        ClientboundClearTitlesPacket var2 = new ClientboundClearTitlesPacket(false);
        for (ServerPlayer var4 : var1) {
            var4.connection.send(var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.title.cleared.single", ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.title.cleared.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int resetTitle(CommandSourceStack var0, Collection<ServerPlayer> var1) {
        ClientboundClearTitlesPacket var2 = new ClientboundClearTitlesPacket(true);
        for (ServerPlayer var4 : var1) {
            var4.connection.send(var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.title.reset.single", ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.title.reset.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int showTitle(CommandSourceStack var0, Collection<ServerPlayer> var1, Component var2, String var3, Function<Component, Packet<?>> var4) throws CommandSyntaxException {
        for (ServerPlayer var6 : var1) {
            var6.connection.send(var4.apply(ComponentUtils.updateForEntity(var0, var2, (Entity)var6, 0)));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.title.show." + var3 + ".single", ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.title.show." + var3 + ".multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int setTimes(CommandSourceStack var0, Collection<ServerPlayer> var1, int var2, int var3, int var4) {
        ClientboundSetTitlesAnimationPacket var5 = new ClientboundSetTitlesAnimationPacket(var2, var3, var4);
        for (ServerPlayer var7 : var1) {
            var7.connection.send(var5);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.title.times.single", ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.title.times.multiple", var1.size()), true);
        }
        return var1.size();
    }
}

