/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.server.level.ServerPlayer;

public class TransferCommand {
    private static final SimpleCommandExceptionType ERROR_NO_PLAYERS = new SimpleCommandExceptionType((Message)Component.translatable("commands.transfer.error.no_players"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("transfer").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(((RequiredArgumentBuilder)Commands.argument("hostname", StringArgumentType.string()).executes(var0 -> TransferCommand.transfer((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), 25565, List.of(((CommandSourceStack)var0.getSource()).getPlayerOrException())))).then(((RequiredArgumentBuilder)Commands.argument("port", IntegerArgumentType.integer((int)1, (int)65535)).executes(var0 -> TransferCommand.transfer((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), List.of(((CommandSourceStack)var0.getSource()).getPlayerOrException())))).then(Commands.argument("players", EntityArgument.players()).executes(var0 -> TransferCommand.transfer((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "players"))))))));
    }

    private static int transfer(CommandSourceStack var0, String var1, int var2, Collection<ServerPlayer> var3) throws CommandSyntaxException {
        if (var3.isEmpty()) {
            throw ERROR_NO_PLAYERS.create();
        }
        for (ServerPlayer var5 : var3) {
            var5.connection.send(new ClientboundTransferPacket(var1, var2));
        }
        if (var3.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.transfer.success.single", ((ServerPlayer)var3.iterator().next()).getDisplayName(), var1, var2), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.transfer.success.multiple", var3.size(), var1, var2), true);
        }
        return var3.size();
    }
}

