/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HexFormat;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.HexColorArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.WaypointArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointStyleAsset;
import net.minecraft.world.waypoints.WaypointStyleAssets;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class WaypointCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("waypoint").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("list").executes(var0 -> WaypointCommand.listWaypoints((CommandSourceStack)var0.getSource())))).then(Commands.literal("modify").then(((RequiredArgumentBuilder)Commands.argument("waypoint", EntityArgument.entity()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("color").then(Commands.argument("color", ColorArgument.color()).executes(var0 -> WaypointCommand.setWaypointColor((CommandSourceStack)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandSourceStack>)var0, "waypoint"), ColorArgument.getColor((CommandContext<CommandSourceStack>)var0, "color"))))).then(Commands.literal("hex").then(Commands.argument("color", HexColorArgument.hexColor()).executes(var0 -> WaypointCommand.setWaypointColor((CommandSourceStack)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandSourceStack>)var0, "waypoint"), HexColorArgument.getHexColor((CommandContext<CommandSourceStack>)var0, "color")))))).then(Commands.literal("reset").executes(var0 -> WaypointCommand.resetWaypointColor((CommandSourceStack)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandSourceStack>)var0, "waypoint")))))).then(((LiteralArgumentBuilder)Commands.literal("style").then(Commands.literal("reset").executes(var0 -> WaypointCommand.setWaypointStyle((CommandSourceStack)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandSourceStack>)var0, "waypoint"), WaypointStyleAssets.DEFAULT)))).then(Commands.literal("set").then(Commands.argument("style", IdentifierArgument.id()).executes(var0 -> WaypointCommand.setWaypointStyle((CommandSourceStack)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandSourceStack>)var0, "waypoint"), ResourceKey.create(WaypointStyleAssets.ROOT_ID, IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "style")))))))))));
    }

    private static int setWaypointStyle(CommandSourceStack var0, WaypointTransmitter var12, ResourceKey<WaypointStyleAsset> var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.style = var2;
        });
        var0.sendSuccess(() -> Component.translatable("commands.waypoint.modify.style"), false);
        return 0;
    }

    private static int setWaypointColor(CommandSourceStack var0, WaypointTransmitter var12, ChatFormatting var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.color = Optional.of(var2.getColor());
        });
        var0.sendSuccess(() -> Component.translatable("commands.waypoint.modify.color", Component.literal(var2.getName()).withStyle(var2)), false);
        return 0;
    }

    private static int setWaypointColor(CommandSourceStack var0, WaypointTransmitter var12, Integer var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.color = Optional.of(var2);
        });
        var0.sendSuccess(() -> Component.translatable("commands.waypoint.modify.color", Component.literal(HexFormat.of().withUpperCase().toHexDigits(ARGB.color(0, (int)var2), 6)).withColor(var2)), false);
        return 0;
    }

    private static int resetWaypointColor(CommandSourceStack var02, WaypointTransmitter var1) {
        WaypointCommand.mutateIcon(var02, var1, var0 -> {
            var0.color = Optional.empty();
        });
        var02.sendSuccess(() -> Component.translatable("commands.waypoint.modify.color.reset"), false);
        return 0;
    }

    private static int listWaypoints(CommandSourceStack var0) {
        ServerLevel var12 = var0.getLevel();
        Set<WaypointTransmitter> var2 = var12.getWaypointManager().transmitters();
        String var3 = var12.dimension().identifier().toString();
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.waypoint.list.empty", var3), false);
            return 0;
        }
        Component var4 = ComponentUtils.formatList(var2.stream().map(var1 -> {
            if (var1 instanceof LivingEntity) {
                LivingEntity var2 = (LivingEntity)var1;
                BlockPos var32 = var2.blockPosition();
                return var2.getFeedbackDisplayName().copy().withStyle(var3 -> var3.withClickEvent(new ClickEvent.SuggestCommand("/execute in " + var3 + " run tp @s " + var32.getX() + " " + var32.getY() + " " + var32.getZ())).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.coordinates.tooltip"))).withColor(var2.waypointIcon().color.orElse(-1)));
            }
            return Component.literal(var1.toString());
        }).toList(), Function.identity());
        var0.sendSuccess(() -> Component.translatable("commands.waypoint.list.success", var2.size(), var3, var4), false);
        return var2.size();
    }

    private static void mutateIcon(CommandSourceStack var0, WaypointTransmitter var1, Consumer<Waypoint.Icon> var2) {
        ServerLevel var3 = var0.getLevel();
        var3.getWaypointManager().untrackWaypoint(var1);
        var2.accept(var1.waypointIcon());
        var3.getWaypointManager().trackWaypoint(var1);
    }
}

