/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.world.level.storage.CommandStorage;

public class StorageDataAccessor
implements DataAccessor {
    static final SuggestionProvider<CommandSourceStack> SUGGEST_STORAGE = (var0, var1) -> SharedSuggestionProvider.suggestResource(StorageDataAccessor.getGlobalTags((CommandContext<CommandSourceStack>)var0).keys(), var1);
    public static final Function<String, DataCommands.DataProvider> PROVIDER = var0 -> new DataCommands.DataProvider((String)var0){
        final /* synthetic */ String val$arg;
        {
            this.val$arg = string;
        }

        @Override
        public DataAccessor access(CommandContext<CommandSourceStack> var0) {
            return new StorageDataAccessor(StorageDataAccessor.getGlobalTags(var0), IdentifierArgument.getId(var0, this.val$arg));
        }

        @Override
        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var0, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var1) {
            return var0.then(Commands.literal("storage").then(var1.apply((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument(this.val$arg, IdentifierArgument.id()).suggests(SUGGEST_STORAGE))));
        }
    };
    private final CommandStorage storage;
    private final Identifier id;

    static CommandStorage getGlobalTags(CommandContext<CommandSourceStack> var0) {
        return ((CommandSourceStack)var0.getSource()).getServer().getCommandStorage();
    }

    StorageDataAccessor(CommandStorage var0, Identifier var1) {
        this.storage = var0;
        this.id = var1;
    }

    @Override
    public void setData(CompoundTag var0) {
        this.storage.set(this.id, var0);
    }

    @Override
    public CompoundTag getData() {
        return this.storage.get(this.id);
    }

    @Override
    public Component getModifiedSuccess() {
        return Component.translatable("commands.data.storage.modified", Component.translationArg(this.id));
    }

    @Override
    public Component getPrintSuccess(Tag var0) {
        return Component.translatable("commands.data.storage.query", Component.translationArg(this.id), NbtUtils.toPrettyComponent(var0));
    }

    @Override
    public Component getPrintSuccess(NbtPathArgument.NbtPath var0, double var1, int var3) {
        return Component.translatable("commands.data.storage.get", var0.asString(), Component.translationArg(this.id), String.format(Locale.ROOT, "%.2f", var1), var3);
    }
}

