/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.slf4j.Logger;

public class DedicatedPlayerList
extends PlayerList {
    private static final Logger LOGGER = LogUtils.getLogger();

    public DedicatedPlayerList(DedicatedServer var0, LayeredRegistryAccess<RegistryLayer> var1, PlayerDataStorage var2) {
        super(var0, var1, var2, var0.notificationManager());
        this.setViewDistance(var0.viewDistance());
        this.setSimulationDistance(var0.simulationDistance());
        this.loadUserBanList();
        this.saveUserBanList();
        this.loadIpBanList();
        this.saveIpBanList();
        this.loadOps();
        this.loadWhiteList();
        this.saveOps();
        if (!this.getWhiteList().getFile().exists()) {
            this.saveWhiteList();
        }
    }

    @Override
    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    private void saveIpBanList() {
        try {
            this.getIpBans().save();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to save ip banlist: ", (Throwable)var0);
        }
    }

    private void saveUserBanList() {
        try {
            this.getBans().save();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to save user banlist: ", (Throwable)var0);
        }
    }

    private void loadIpBanList() {
        try {
            this.getIpBans().load();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to load ip banlist: ", (Throwable)var0);
        }
    }

    private void loadUserBanList() {
        try {
            this.getBans().load();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to load user banlist: ", (Throwable)var0);
        }
    }

    private void loadOps() {
        try {
            this.getOps().load();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to load operators list: ", (Throwable)var0);
        }
    }

    private void saveOps() {
        try {
            this.getOps().save();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to save operators list: ", (Throwable)var0);
        }
    }

    private void loadWhiteList() {
        try {
            this.getWhiteList().load();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to load white-list: ", (Throwable)var0);
        }
    }

    private void saveWhiteList() {
        try {
            this.getWhiteList().save();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to save white-list: ", (Throwable)var0);
        }
    }

    @Override
    public boolean isWhiteListed(NameAndId var0) {
        return !this.isUsingWhitelist() || this.isOp(var0) || this.getWhiteList().isWhiteListed(var0);
    }

    @Override
    public DedicatedServer getServer() {
        return (DedicatedServer)super.getServer();
    }

    @Override
    public boolean canBypassPlayerLimit(NameAndId var0) {
        return this.getOps().canBypassPlayerLimit(var0);
    }

    @Override
    public /* synthetic */ MinecraftServer getServer() {
        return this.getServer();
    }
}

