/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.action;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.functions.StringTemplate;

public class ParsedTemplate {
    public static final Codec<ParsedTemplate> CODEC = Codec.STRING.comapFlatMap(ParsedTemplate::parse, var0 -> var0.raw);
    public static final Codec<String> VARIABLE_CODEC = Codec.STRING.validate(var0 -> StringTemplate.isValidVariableName(var0) ? DataResult.success((Object)var0) : DataResult.error(() -> var0 + " is not a valid input name"));
    private final String raw;
    private final StringTemplate parsed;

    private ParsedTemplate(String var0, StringTemplate var1) {
        this.raw = var0;
        this.parsed = var1;
    }

    private static DataResult<ParsedTemplate> parse(String var0) {
        StringTemplate var1;
        try {
            var1 = StringTemplate.fromString(var0);
        }
        catch (Exception var2) {
            return DataResult.error(() -> "Failed to parse template " + var0 + ": " + var2.getMessage());
        }
        return DataResult.success((Object)new ParsedTemplate(var0, var1));
    }

    public String instantiate(Map<String, String> var0) {
        List<String> var12 = this.parsed.variables().stream().map(var1 -> var0.getOrDefault(var1, "")).toList();
        return this.parsed.substitute(var12);
    }
}

