/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.Identifier;
import net.minecraft.util.GsonHelper;
import org.jspecify.annotations.Nullable;

public class JsonRPCUtils {
    public static final String JSON_RPC_VERSION = "2.0";
    public static final String OPEN_RPC_VERSION = "1.3.2";

    public static JsonObject createSuccessResult(JsonElement var0, JsonElement var1) {
        JsonObject var2 = new JsonObject();
        var2.addProperty("jsonrpc", JSON_RPC_VERSION);
        var2.add("id", var0);
        var2.add("result", var1);
        return var2;
    }

    public static JsonObject createRequest(@Nullable Integer var0, Identifier var1, List<JsonElement> var2) {
        JsonObject var3 = new JsonObject();
        var3.addProperty("jsonrpc", JSON_RPC_VERSION);
        if (var0 != null) {
            var3.addProperty("id", (Number)var0);
        }
        var3.addProperty("method", var1.toString());
        if (!var2.isEmpty()) {
            JsonArray var4 = new JsonArray(var2.size());
            for (JsonElement var6 : var2) {
                var4.add(var6);
            }
            var3.add("params", (JsonElement)var4);
        }
        return var3;
    }

    public static JsonObject createError(JsonElement var0, String var1, int var2, @Nullable String var3) {
        JsonObject var4 = new JsonObject();
        var4.addProperty("jsonrpc", JSON_RPC_VERSION);
        var4.add("id", var0);
        JsonObject var5 = new JsonObject();
        var5.addProperty("code", (Number)var2);
        var5.addProperty("message", var1);
        if (var3 != null && !var3.isBlank()) {
            var5.addProperty("data", var3);
        }
        var4.add("error", (JsonElement)var5);
        return var4;
    }

    public static @Nullable JsonElement getRequestId(JsonObject var0) {
        return var0.get("id");
    }

    public static @Nullable String getMethodName(JsonObject var0) {
        return GsonHelper.getAsString(var0, "method", null);
    }

    public static @Nullable JsonElement getParams(JsonObject var0) {
        return var0.get("params");
    }

    public static @Nullable JsonElement getResult(JsonObject var0) {
        return var0.get("result");
    }

    public static @Nullable JsonObject getError(JsonObject var0) {
        return GsonHelper.getAsJsonObject(var0, "error", null);
    }
}

