/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.stream.Stream;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer server;
    private final GameRules gameRules;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftGameRuleServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.gameRules = var0.getWorldData().getGameRules();
        this.jsonrpcLogger = var1;
    }

    @Override
    public <T> GameRulesService.GameRuleUpdate<T> updateGameRule(GameRulesService.GameRuleUpdate<T> var0, ClientInfo var1) {
        GameRule<T> var2 = var0.gameRule();
        T var3 = this.gameRules.get(var2);
        T var4 = var0.value();
        this.gameRules.set(var2, var4, this.server);
        this.jsonrpcLogger.log(var1, "Game rule '{}' updated from '{}' to '{}'", var2.id(), var2.serialize(var3), var2.serialize(var4));
        return var0;
    }

    @Override
    public <T> GameRulesService.GameRuleUpdate<T> getTypedRule(GameRule<T> var0, T var1) {
        return new GameRulesService.GameRuleUpdate<T>(var0, var1);
    }

    @Override
    public Stream<GameRule<?>> getAvailableGameRules() {
        return this.gameRules.availableRules();
    }

    @Override
    public <T> T getRuleValue(GameRule<T> var0) {
        return this.gameRules.get(var0);
    }
}

