/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerStateService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class MinecraftServerStateServiceImpl
implements MinecraftServerStateService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftServerStateServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public boolean isReady() {
        return this.server.isReady();
    }

    @Override
    public boolean saveEverything(boolean var0, boolean var1, boolean var2, ClientInfo var3) {
        this.jsonrpcLogger.log(var3, "Save everything. SuppressLogs: {}, flush: {}, force: {}", var0, var1, var2);
        return this.server.saveEverything(var0, var1, var2);
    }

    @Override
    public void halt(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Halt server. WaitForShutdown: {}", var0);
        this.server.halt(var0);
    }

    @Override
    public void sendSystemMessage(Component var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Send system message: '{}'", var0.getString());
        this.server.sendSystemMessage(var0);
    }

    @Override
    public void sendSystemMessage(Component var0, boolean var1, Collection<ServerPlayer> var2, ClientInfo var3) {
        List<String> var4 = var2.stream().map(Player::getPlainTextName).toList();
        this.jsonrpcLogger.log(var3, "Send system message to '{}' players (overlay: {}): '{}'", var4.size(), var1, var0.getString());
        for (ServerPlayer var6 : var2) {
            if (var1) {
                var6.sendSystemMessage(var0, true);
                continue;
            }
            var6.sendSystemMessage(var0);
        }
    }

    @Override
    public void broadcastSystemMessage(Component var0, boolean var1, ClientInfo var2) {
        this.jsonrpcLogger.log(var2, "Broadcast system message (overlay: {}): '{}'", var1, var0.getString());
        for (ServerPlayer var4 : this.server.getPlayerList().getPlayers()) {
            if (var1) {
                var4.sendSystemMessage(var0, true);
                continue;
            }
            var4.sendSystemMessage(var0);
        }
    }
}

