/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;

public class BanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<UserBanDto> get(MinecraftApi var02) {
        return var02.banListService().getUserBanEntries().stream().filter(var0 -> var0.getUser() != null).map(UserBan::from).map(UserBanDto::from).toList();
    }

    public static List<UserBanDto> add(MinecraftApi var0, List<UserBanDto> var1, ClientInfo var2) {
        List<CompletableFuture> var3 = var1.stream().map(var12 -> var0.playerListService().getUser(var12.player().id(), var12.player().name()).thenApply(var1 -> var1.map(var12::toUserBan))).toList();
        for (Optional var5 : Util.sequence(var3).join()) {
            if (var5.isEmpty()) continue;
            UserBan var6 = (UserBan)var5.get();
            var0.banListService().addUserBan(var6.toBanEntry(), var2);
            ServerPlayer var7 = var0.playerListService().getPlayer(((UserBan)var5.get()).player().id());
            if (var7 == null) continue;
            var7.connection.disconnect(Component.translatable("multiplayer.disconnect.banned"));
        }
        return BanlistService.get(var0);
    }

    public static List<UserBanDto> clear(MinecraftApi var0, ClientInfo var1) {
        var0.banListService().clearUserBans(var1);
        return BanlistService.get(var0);
    }

    public static List<UserBanDto> remove(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var2) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        for (Optional var5 : Util.sequence(var3).join()) {
            if (var5.isEmpty()) continue;
            var0.banListService().removeUserBan((NameAndId)var5.get(), var2);
        }
        return BanlistService.get(var0);
    }

    public static List<UserBanDto> set(MinecraftApi var02, List<UserBanDto> var13, ClientInfo var22) {
        List<CompletableFuture> var3 = var13.stream().map(var12 -> var02.playerListService().getUser(var12.player().id(), var12.player().name()).thenApply(var1 -> var1.map(var12::toUserBan))).toList();
        Set var4 = Util.sequence(var3).join().stream().flatMap(Optional::stream).collect(Collectors.toSet());
        Set var5 = var02.banListService().getUserBanEntries().stream().filter(var0 -> var0.getUser() != null).map(UserBan::from).collect(Collectors.toSet());
        var5.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var02.banListService().removeUserBan(var2.player(), var22));
        var4.stream().filter(var1 -> !var5.contains(var1)).forEach(var2 -> {
            var02.banListService().addUserBan(var2.toBanEntry(), var22);
            ServerPlayer var3 = var02.playerListService().getPlayer(var2.player().id());
            if (var3 != null) {
                var3.connection.disconnect(Component.translatable("multiplayer.disconnect.banned"));
            }
        });
        return BanlistService.get(var02);
    }

    record UserBan(NameAndId player, @Nullable String reason, String source, Optional<Instant> expires) {
        static UserBan from(UserBanListEntry var0) {
            return new UserBan(Objects.requireNonNull((NameAndId)var0.getUser()), var0.getReason(), var0.getSource(), Optional.ofNullable(var0.getExpires()).map(Date::toInstant));
        }

        UserBanListEntry toBanEntry() {
            return new UserBanListEntry(new NameAndId(this.player().id(), this.player().name()), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record UserBanDto(PlayerDto player, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<UserBanDto> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(UserBanDto::player), (App)Codec.STRING.optionalFieldOf("reason").forGetter(UserBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(UserBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(UserBanDto::expires)).apply((Applicative)var0, UserBanDto::new));

        private static UserBanDto from(UserBan var0) {
            return new UserBanDto(PlayerDto.from(var0.player()), Optional.ofNullable(var0.reason()), Optional.of(var0.source()), var0.expires());
        }

        public static UserBanDto from(UserBanListEntry var0) {
            return UserBanDto.from(UserBan.from(var0));
        }

        private UserBan toUserBan(NameAndId var0) {
            return new UserBan(var0, this.reason().orElse(null), this.source().orElse(BanlistService.BAN_SOURCE), this.expires());
        }
    }
}

