/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleType;

public class GameRulesService {
    public static List<GameRuleUpdate<?>> get(MinecraftApi var0) {
        ArrayList var1 = new ArrayList();
        var0.gameRuleService().getAvailableGameRules().forEach(var2 -> GameRulesService.addGameRule(var0, var2, var1));
        return var1;
    }

    private static <T> void addGameRule(MinecraftApi var0, GameRule<T> var1, List<GameRuleUpdate<?>> var2) {
        T var3 = var0.gameRuleService().getRuleValue(var1);
        var2.add(GameRulesService.getTypedRule(var0, var1, Objects.requireNonNull(var3)));
    }

    public static <T> GameRuleUpdate<T> getTypedRule(MinecraftApi var0, GameRule<T> var1, T var2) {
        return var0.gameRuleService().getTypedRule(var1, var2);
    }

    public static <T> GameRuleUpdate<T> update(MinecraftApi var0, GameRuleUpdate<T> var1, ClientInfo var2) {
        return var0.gameRuleService().updateGameRule(var1, var2);
    }

    public record GameRuleUpdate<T>(GameRule<T> gameRule, T value) {
        public static final Codec<GameRuleUpdate<?>> TYPED_CODEC = BuiltInRegistries.GAME_RULE.byNameCodec().dispatch("key", GameRuleUpdate::gameRule, GameRuleUpdate::getValueAndTypeCodec);
        public static final Codec<GameRuleUpdate<?>> CODEC = BuiltInRegistries.GAME_RULE.byNameCodec().dispatch("key", GameRuleUpdate::gameRule, GameRuleUpdate::getValueCodec);

        private static <T> MapCodec<? extends GameRuleUpdate<T>> getValueCodec(GameRule<T> var0) {
            return var0.valueCodec().fieldOf("value").xmap(var1 -> new GameRuleUpdate<Object>(var0, var1), GameRuleUpdate::value);
        }

        private static <T> MapCodec<? extends GameRuleUpdate<T>> getValueAndTypeCodec(GameRule<T> var0) {
            return RecordCodecBuilder.mapCodec(var12 -> var12.group((App)StringRepresentable.fromEnum(GameRuleType::values).fieldOf("type").forGetter(var0 -> var0.gameRule.gameRuleType()), (App)var0.valueCodec().fieldOf("value").forGetter(GameRuleUpdate::value)).apply((Applicative)var12, (var1, var2) -> GameRuleUpdate.getUntypedRule(var0, var1, var2)));
        }

        private static <T> GameRuleUpdate<T> getUntypedRule(GameRule<T> var0, GameRuleType var1, T var2) {
            if (var0.gameRuleType() != var1) {
                throw new InvalidParameterJsonRpcException("Stated type \"" + String.valueOf(var1) + "\" mismatches with actual type \"" + String.valueOf(var0.gameRuleType()) + "\" of gamerule \"" + var0.id() + "\"");
            }
            return new GameRuleUpdate<T>(var0, var2);
        }
    }
}

