/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public interface ChunkResult<T> {
    public static <T> ChunkResult<T> of(T var0) {
        return new Success<T>(var0);
    }

    public static <T> ChunkResult<T> error(String var0) {
        return ChunkResult.error(() -> var0);
    }

    public static <T> ChunkResult<T> error(Supplier<String> var0) {
        return new Fail(var0);
    }

    public boolean isSuccess();

    public @Nullable T orElse(@Nullable T var1);

    public static <R> @Nullable R orElse(ChunkResult<? extends R> var0, @Nullable R var1) {
        R var2 = var0.orElse(null);
        return var2 != null ? var2 : (R)var1;
    }

    public @Nullable String getError();

    public ChunkResult<T> ifSuccess(Consumer<T> var1);

    public <R> ChunkResult<R> map(Function<T, R> var1);

    public <E extends Throwable> T orElseThrow(Supplier<E> var1) throws E;

    public record Success<T>(T value) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T orElse(@Nullable T var0) {
            return this.value;
        }

        @Override
        public @Nullable String getError() {
            return null;
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> var0) {
            var0.accept(this.value);
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> var0) {
            return new Success<R>(var0.apply(this.value));
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> var0) throws E {
            return this.value;
        }
    }

    public record Fail<T>(Supplier<String> error) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public @Nullable T orElse(@Nullable T var0) {
            return var0;
        }

        @Override
        public String getError() {
            return this.error.get();
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> var0) {
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> var0) {
            return new Fail<T>(this.error);
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> var0) throws E {
            throw (Throwable)var0.get();
        }
    }
}

