/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ServerPlayerGameMode {
    private static final double FLIGHT_DISABLE_RANGE = 1.0;
    private static final Logger LOGGER = LogUtils.getLogger();
    protected ServerLevel level;
    protected final ServerPlayer player;
    private GameType gameModeForPlayer = GameType.DEFAULT_MODE;
    private @Nullable GameType previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPos interactPosition;
    public InteractionHand interactHand;
    public ItemStack interactItemStack;

    public ServerPlayerGameMode(ServerPlayer entityplayer) {
        this.player = entityplayer;
        this.level = entityplayer.level();
    }

    public boolean changeGameModeForPlayer(GameType enumgamemode) {
        if (enumgamemode == this.gameModeForPlayer) {
            return false;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), GameMode.getByValue((int)enumgamemode.getId()));
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        Abilities playerabilities = this.player.getAbilities();
        this.setGameModeForPlayer(enumgamemode, this.gameModeForPlayer);
        if (playerabilities.flying && enumgamemode != GameType.SPECTATOR && this.isInRangeOfGround()) {
            playerabilities.flying = false;
        }
        this.player.onUpdateAbilities();
        this.level.getServer().getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.player), this.player);
        this.level.updateSleepingPlayerList();
        if (enumgamemode == GameType.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return true;
    }

    protected void setGameModeForPlayer(GameType enumgamemode, @Nullable GameType enumgamemode1) {
        this.previousGameModeForPlayer = enumgamemode1;
        this.gameModeForPlayer = enumgamemode;
        Abilities playerabilities = this.player.getAbilities();
        enumgamemode.updatePlayerAbilities(playerabilities);
    }

    private boolean isInRangeOfGround() {
        List<VoxelShape> list = Entity.collectAllColliders(this.player, this.level, this.player.getBoundingBox());
        return list.isEmpty() && this.player.getAvailableSpaceBelow(1.0) < 1.0;
    }

    public GameType getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    public @Nullable GameType getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        this.gameTicks = MinecraftServer.currentTick;
        if (this.hasDelayedDestroy) {
            net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(this.delayedDestroyPos);
            if (iblockdata.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float f = this.incrementDestroyProgress(iblockdata, this.delayedDestroyPos, this.delayedTickStart);
                if (f >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            net.minecraft.world.level.block.state.BlockState iblockdata1 = this.level.getBlockState(this.destroyPos);
            if (iblockdata1.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress(iblockdata1, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(net.minecraft.world.level.block.state.BlockState iblockdata, BlockPos blockposition, int i) {
        int j = this.gameTicks - i;
        float f = iblockdata.getDestroyProgress(this.player, this.player.level(), blockposition) * (float)(j + 1);
        int k = (int)(f * 10.0f);
        if (k != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), blockposition, k);
            this.lastSentState = k;
        }
        return f;
    }

    private void debugLogging(BlockPos blockposition, boolean flag, int i, String s) {
        if (SharedConstants.DEBUG_BLOCK_BREAK) {
            LOGGER.debug("Server ACK {} {} {} {}", new Object[]{i, blockposition, flag, s});
        }
    }

    public void handleBlockBreakAction(BlockPos blockposition, ServerboundPlayerActionPacket.Action packetplayinblockdig_enumplayerdigtype, Direction enumdirection, int i, int j) {
        if (!this.player.isWithinBlockInteractionRange(blockposition, 1.0)) {
            this.debugLogging(blockposition, false, j, "too far");
        } else if (blockposition.getY() > i) {
            this.player.connection.send(new ClientboundBlockUpdatePacket(blockposition, this.level.getBlockState(blockposition)));
            this.debugLogging(blockposition, false, j, "too high");
        } else if (packetplayinblockdig_enumplayerdigtype == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, blockposition)) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
                this.player.connection.send(new ClientboundBlockUpdatePacket(blockposition, this.level.getBlockState(blockposition)));
                this.debugLogging(blockposition, false, j, "may not interact");
                this.player.connection.send(new ClientboundBlockChangedAckPacket(j));
                BlockEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.player.getInventory().getSelectedItem(), InteractionHand.MAIN_HAND);
            if (event.isCancelled()) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                this.player.connection.send(new ClientboundBlockChangedAckPacket(j));
                BlockEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return;
            }
            if (this.player.getAbilities().instabuild) {
                this.destroyAndAck(blockposition, j, "creative destroy");
                return;
            }
            if (this.player.getMainHandItem().is(Items.DEBUG_STICK) && ((DebugStickItem)Items.DEBUG_STICK).handleInteraction(this.player, this.level.getBlockState(blockposition), this.level, blockposition, false, this.player.getMainHandItem())) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                return;
            }
            if (this.player.blockActionRestricted(this.level, blockposition, this.gameModeForPlayer)) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(blockposition, this.level.getBlockState(blockposition)));
                this.debugLogging(blockposition, false, j, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f = 1.0f;
            net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(blockposition);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                net.minecraft.world.level.block.state.BlockState data = this.level.getBlockState(blockposition);
                if (data.getBlock() instanceof DoorBlock) {
                    boolean bottom = data.getValue(DoorBlock.HALF) == DoubleBlockHalf.LOWER;
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, bottom ? blockposition.above() : blockposition.below()));
                } else if (data.getBlock() instanceof TrapDoorBlock) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                }
            } else if (!iblockdata.isAir()) {
                EnchantmentHelper.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EquipmentSlot.MAINHAND, Vec3.atCenterOf(blockposition), iblockdata, item -> this.player.onEquippedItemBroken((Item)item, EquipmentSlot.MAINHAND));
                iblockdata.attack(this.level, blockposition, this.player);
                f = iblockdata.getDestroyProgress(this.player, this.player.level(), blockposition);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f > 1.0f) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.player, blockposition, this.player.getInventory().getSelectedItem(), f >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!iblockdata.isAir() && f >= 1.0f) {
                this.destroyAndAck(blockposition, j, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(blockposition, false, j, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = blockposition.immutable();
                int k = (int)(f * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), blockposition, k);
                this.debugLogging(blockposition, true, j, "actual start of destroying");
                this.lastSentState = k;
            }
        } else if (packetplayinblockdig_enumplayerdigtype == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (blockposition.equals(this.destroyPos)) {
                int l = this.gameTicks - this.destroyProgressStart;
                net.minecraft.world.level.block.state.BlockState iblockdata1 = this.level.getBlockState(blockposition);
                if (!iblockdata1.isAir()) {
                    float f1 = iblockdata1.getDestroyProgress(this.player, this.player.level(), blockposition) * (float)(l + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), blockposition, -1);
                        this.destroyAndAck(blockposition, j, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = blockposition;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(blockposition, true, j, "stopped destroying");
        } else if (packetplayinblockdig_enumplayerdigtype == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, blockposition)) {
                LOGGER.debug("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)blockposition);
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(blockposition, true, j, "aborted mismatched destroying");
            }
            this.level.destroyBlockProgress(this.player.getId(), blockposition, -1);
            this.debugLogging(blockposition, true, j, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.player, blockposition, this.player.getInventory().getSelectedItem());
        }
    }

    public void destroyAndAck(BlockPos blockposition, int i, String s) {
        if (this.destroyBlock(blockposition, i)) {
            this.debugLogging(blockposition, true, i, s);
        } else {
            this.player.connection.send(new ClientboundBlockUpdatePacket(blockposition, this.level.getBlockState(blockposition)));
            this.debugLogging(blockposition, false, i, s);
        }
    }

    public boolean destroyBlock(BlockPos blockposition) {
        return this.destroyBlock(blockposition, -1);
    }

    public boolean destroyBlock(BlockPos blockposition, int ack) {
        net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(blockposition);
        CraftBlock bblock = CraftBlock.at(this.level, blockposition);
        BlockBreakEvent event = null;
        if (this.player instanceof ServerPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.player.getMainHandItem().canDestroyBlock(iblockdata, this.level, blockposition, this.player);
            if (this.level.getBlockEntity(blockposition) == null && !isSwordNoBreak) {
                ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(blockposition, Blocks.AIR.defaultBlockState());
                this.player.connection.send(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (org.bukkit.entity.Player)this.player.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            net.minecraft.world.level.block.state.BlockState nmsData = this.level.getBlockState(blockposition);
            Block nmsBlock = nmsData.getBlock();
            ItemStack itemstack = this.player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (nmsBlock != null && !event.isCancelled() && !this.isCreative() && this.player.hasCorrectToolForDrops(nmsBlock.defaultBlockState())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.level, blockposition, itemstack, true));
            }
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition));
                for (Direction dir : Direction.values()) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.level, blockposition.relative(dir)));
                }
                this.player.connection.send(new ClientboundBlockChangedAckPacket(ack));
                BlockEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return false;
            }
        }
        if ((iblockdata = this.level.getBlockState(blockposition)).isAir()) {
            return false;
        }
        BlockEntity tileentity = this.level.getBlockEntity(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof GameMasterBlock && !this.player.canUseGameMasterBlocks()) {
            this.level.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, blockposition, this.gameModeForPlayer)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.level.captureDrops = new ArrayList();
        net.minecraft.world.level.block.state.BlockState iblockdata1 = block.playerWillDestroy(this.level, blockposition, iblockdata, this.player);
        boolean flag = this.level.removeBlock(blockposition, false);
        if (SharedConstants.DEBUG_BLOCK_BREAK) {
            LOGGER.info("server broke {} {} -> {}", new Object[]{blockposition, iblockdata1, this.level.getBlockState(blockposition)});
        }
        if (flag) {
            block.destroy(this.level, blockposition, iblockdata1);
        }
        if (!this.player.preventsBlockDrops()) {
            ItemStack itemstack = this.player.getMainHandItem();
            ItemStack itemstack1 = itemstack.copy();
            boolean flag1 = this.player.hasCorrectToolForDrops(iblockdata1);
            itemstack.mineBlock(this.level, iblockdata1, blockposition, this.player);
            if (flag && flag1 && event.isDropItems()) {
                block.playerDestroy(this.level, this.player, blockposition, iblockdata1, tileentity, itemstack1);
            }
        }
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.player, this.level.captureDrops);
        }
        this.level.captureDrops = null;
        if (flag && event != null) {
            iblockdata.getBlock().popExperience(this.level, blockposition, event.getExpToDrop());
        }
        return true;
    }

    public InteractionResult useItem(ServerPlayer entityplayer, Level world, ItemStack itemstack, InteractionHand enumhand) {
        ItemStack itemstack1;
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (entityplayer.getCooldowns().isOnCooldown(itemstack)) {
            return InteractionResult.PASS;
        }
        int i = itemstack.getCount();
        int j = itemstack.getDamageValue();
        InteractionResult enuminteractionresult = itemstack.use(world, entityplayer, enumhand);
        if (enuminteractionresult instanceof InteractionResult.Success) {
            InteractionResult.Success enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult;
            itemstack1 = Objects.requireNonNullElse(enuminteractionresult_d.heldItemTransformedTo(), entityplayer.getItemInHand(enumhand));
        } else {
            itemstack1 = entityplayer.getItemInHand(enumhand);
        }
        if (itemstack1 == itemstack && itemstack1.getCount() == i && itemstack1.getUseDuration(entityplayer) <= 0 && itemstack1.getDamageValue() == j) {
            return enuminteractionresult;
        }
        if (enuminteractionresult instanceof InteractionResult.Fail && itemstack1.getUseDuration(entityplayer) > 0 && !entityplayer.isUsingItem()) {
            return enuminteractionresult;
        }
        if (itemstack != itemstack1) {
            entityplayer.setItemInHand(enumhand, itemstack1);
        }
        if (itemstack1.isEmpty()) {
            entityplayer.setItemInHand(enumhand, ItemStack.EMPTY);
        }
        if (!entityplayer.isUsingItem()) {
            entityplayer.inventoryMenu.sendAllDataToRemote();
        }
        return enuminteractionresult;
    }

    public InteractionResult useItemOn(ServerPlayer entityplayer, Level world, ItemStack itemstack, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        net.minecraft.world.level.block.state.BlockState iblockdata = world.getBlockState(blockposition);
        boolean cancelledBlock = false;
        if (!iblockdata.getBlock().isEnabled(world.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider itileinventory = iblockdata.getMenuProvider(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof MenuProvider);
        }
        if (entityplayer.getCooldowns().isOnCooldown(itemstack)) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)entityplayer, Action.RIGHT_CLICK_BLOCK, blockposition, movingobjectpositionblock.getDirection(), itemstack, cancelledBlock, enumhand, movingobjectpositionblock.getLocation());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.immutable();
        this.interactHand = enumhand;
        this.interactItemStack = itemstack.copy();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.getBlock() instanceof DoorBlock) {
                boolean bottom = iblockdata.getValue(DoorBlock.HALF) == DoubleBlockHalf.LOWER;
                entityplayer.connection.send(new ClientboundBlockUpdatePacket(world, bottom ? blockposition.above() : blockposition.below()));
            } else if (iblockdata.getBlock() instanceof CakeBlock) {
                entityplayer.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.getItem() instanceof DoubleHighBlockItem) {
                entityplayer.connection.send(new ClientboundBlockUpdatePacket(world, blockposition.relative(movingobjectpositionblock.getDirection()).above()));
                entityplayer.connection.send(new ClientboundBlockUpdatePacket(world, blockposition.above()));
            }
            entityplayer.getBukkitEntity().updateInventory();
            return event.useItemInHand() != Event.Result.ALLOW ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider itileinventory = iblockdata.getMenuProvider(world, blockposition);
            if (itileinventory != null) {
                entityplayer.openMenu(itileinventory);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        boolean flag = !entityplayer.getMainHandItem().isEmpty() || !entityplayer.getOffhandItem().isEmpty();
        boolean flag1 = entityplayer.isSecondaryUseActive() && flag;
        ItemStack itemstack1 = itemstack.copy();
        if (!flag1) {
            InteractionResult enuminteractionresult1;
            InteractionResult enuminteractionresult = iblockdata.useItemOn(entityplayer.getItemInHand(enumhand), world, entityplayer, enumhand, movingobjectpositionblock);
            if (enuminteractionresult.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(entityplayer, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (enuminteractionresult instanceof InteractionResult.TryEmptyHandInteraction && enumhand == InteractionHand.MAIN_HAND && (enuminteractionresult1 = iblockdata.useWithoutItem(world, entityplayer, movingobjectpositionblock)).consumesAction()) {
                CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(entityplayer, blockposition);
                return enuminteractionresult1;
            }
        }
        if (!itemstack.isEmpty() && !this.interactResult) {
            InteractionResult enuminteractionresult2;
            UseOnContext itemactioncontext = new UseOnContext(entityplayer, enumhand, movingobjectpositionblock);
            if (entityplayer.hasInfiniteMaterials()) {
                int i = itemstack.getCount();
                enuminteractionresult2 = itemstack.useOn(itemactioncontext);
                itemstack.setCount(i);
            } else {
                enuminteractionresult2 = itemstack.useOn(itemactioncontext);
            }
            if (enuminteractionresult2.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(entityplayer, blockposition, itemstack1);
            }
            return enuminteractionresult2;
        }
        return InteractionResult.PASS;
    }

    public void setLevel(ServerLevel worldserver) {
        this.level = worldserver;
    }
}

