/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import net.minecraft.SharedConstants;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MIN_CHUNKS_PER_TICK = 0.01f;
    public static final float MAX_CHUNKS_PER_TICK = 64.0f;
    private static final float START_CHUNKS_PER_TICK = 9.0f;
    private static final int MAX_UNACKNOWLEDGED_BATCHES = 10;
    private final LongSet pendingChunks = new LongOpenHashSet();
    private final boolean memoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkSender(boolean var0) {
        this.memoryConnection = var0;
    }

    public void markChunkPendingToSend(LevelChunk var0) {
        this.pendingChunks.add(var0.getPos().toLong());
    }

    public void dropChunk(ServerPlayer var0, ChunkPos var1) {
        if (!this.pendingChunks.remove(var1.toLong()) && var0.isAlive()) {
            var0.connection.send(new ClientboundForgetLevelChunkPacket(var1));
        }
    }

    public void sendNextChunks(ServerPlayer var0) {
        if (this.unacknowledgedBatches >= this.maxUnacknowledgedBatches) {
            return;
        }
        float var1 = Math.max(1.0f, this.desiredChunksPerTick);
        this.batchQuota = Math.min(this.batchQuota + this.desiredChunksPerTick, var1);
        if (this.batchQuota < 1.0f) {
            return;
        }
        if (this.pendingChunks.isEmpty()) {
            return;
        }
        ServerLevel var2 = var0.level();
        ChunkMap var3 = var2.getChunkSource().chunkMap;
        List<LevelChunk> var4 = this.collectChunksToSend(var3, var0.chunkPosition());
        if (var4.isEmpty()) {
            return;
        }
        ServerGamePacketListenerImpl var5 = var0.connection;
        ++this.unacknowledgedBatches;
        var5.send(ClientboundChunkBatchStartPacket.INSTANCE);
        for (LevelChunk var7 : var4) {
            PlayerChunkSender.sendChunk(var5, var2, var7);
        }
        var5.send(new ClientboundChunkBatchFinishedPacket(var4.size()));
        this.batchQuota -= (float)var4.size();
    }

    private static void sendChunk(ServerGamePacketListenerImpl var0, ServerLevel var1, LevelChunk var2) {
        var0.send(new ClientboundLevelChunkWithLightPacket(var2, var1.getLightEngine(), null, null));
        ChunkPos var3 = var2.getPos();
        if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
            LOGGER.debug("SEN {}", (Object)var3);
        }
        var1.debugSynchronizers().startTrackingChunk(var0.player, var2.getPos());
    }

    /*
     * Unable to fully structure code
     */
    private List<LevelChunk> collectChunksToSend(ChunkMap var0, ChunkPos var1) {
        var3 = Mth.floor(this.batchQuota);
        if (this.memoryConnection) ** GOTO lbl7
        if (this.pendingChunks.size() <= var3) {
lbl7:
            // 2 sources

            var2 = this.pendingChunks.longStream().mapToObj((LongFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (J)Ljava/lang/Object;, getChunkToSend(long ), (J)Lnet/minecraft/world/level/chunk/LevelChunk;)((ChunkMap)var0)).filter((Predicate<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lnet/minecraft/world/level/chunk/LevelChunk;)Z)()).sorted(Comparator.comparingInt((ToIntFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$collectChunksToSend$0(net.minecraft.world.level.ChunkPos net.minecraft.world.level.chunk.LevelChunk ), (Lnet/minecraft/world/level/chunk/LevelChunk;)I)((ChunkPos)var1))).toList();
        } else {
            var2 = ((List)this.pendingChunks.stream().collect(Comparators.least((int)var3, Comparator.comparingInt((ToIntFunction<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, distanceSquared(long ), (Ljava/lang/Long;)I)((ChunkPos)var1))))).stream().mapToLong((ToLongFunction<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, longValue(), (Ljava/lang/Long;)J)()).mapToObj((LongFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (J)Ljava/lang/Object;, getChunkToSend(long ), (J)Lnet/minecraft/world/level/chunk/LevelChunk;)((ChunkMap)var0)).filter((Predicate<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lnet/minecraft/world/level/chunk/LevelChunk;)Z)()).toList();
        }
        for (LevelChunk var5 : var2) {
            this.pendingChunks.remove(var5.getPos().toLong());
        }
        return var2;
    }

    public void onChunkBatchReceivedByClient(float var0) {
        --this.unacknowledgedBatches;
        float f = this.desiredChunksPerTick = Double.isNaN(var0) ? 0.01f : Mth.clamp(var0, 0.01f, 64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.batchQuota = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }

    public boolean isPending(long var0) {
        return this.pendingChunks.contains(var0);
    }

    private static /* synthetic */ int lambda$collectChunksToSend$0(ChunkPos var0, LevelChunk var1) {
        return var0.distanceSquared(var1.getPos());
    }
}

