/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.notifications;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.util.Util;

public class ServerActivityMonitor {
    private final long minimumMillisBetweenNotifications;
    private final AtomicLong lastNotificationTime = new AtomicLong();
    private final AtomicBoolean serverActivity = new AtomicBoolean(false);
    private final NotificationManager notificationManager;

    public ServerActivityMonitor(NotificationManager var0, int var1) {
        this.notificationManager = var0;
        this.minimumMillisBetweenNotifications = TimeUnit.SECONDS.toMillis(var1);
    }

    public void tick() {
        this.processWithRateLimit();
    }

    public void reportLoginActivity() {
        this.serverActivity.set(true);
        this.processWithRateLimit();
    }

    private void processWithRateLimit() {
        long var0 = Util.getMillis();
        if (this.serverActivity.get() && var0 - this.lastNotificationTime.get() >= this.minimumMillisBetweenNotifications) {
            this.notificationManager.serverActivityOccured();
            this.lastNotificationTime.set(Util.getMillis());
        }
        this.serverActivity.set(false);
    }
}

