/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.util.IdentifierPattern;

public class ResourceFilterSection {
    private static final Codec<ResourceFilterSection> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.list(IdentifierPattern.CODEC).fieldOf("block").forGetter(var0 -> var0.blockList)).apply((Applicative)var02, ResourceFilterSection::new));
    public static final MetadataSectionType<ResourceFilterSection> TYPE = new MetadataSectionType<ResourceFilterSection>("filter", CODEC);
    private final List<IdentifierPattern> blockList;

    public ResourceFilterSection(List<IdentifierPattern> var0) {
        this.blockList = List.copyOf(var0);
    }

    public boolean isNamespaceFiltered(String var0) {
        return this.blockList.stream().anyMatch(var1 -> var1.namespacePredicate().test(var0));
    }

    public boolean isPathFiltered(String var0) {
        return this.blockList.stream().anyMatch(var1 -> var1.pathPredicate().test(var0));
    }
}

