/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.io.File;
import java.net.SocketAddress;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;
import org.jspecify.annotations.Nullable;

public class IpBanList
extends StoredUserList<String, IpBanListEntry> {
    public IpBanList(File var0, NotificationService var1) {
        super(var0, var1);
    }

    @Override
    protected StoredUserEntry<String> createEntry(JsonObject var0) {
        return new IpBanListEntry(var0);
    }

    public boolean isBanned(SocketAddress var0) {
        String var1 = this.getIpFromAddress(var0);
        return this.contains(var1);
    }

    public boolean isBanned(String var0) {
        return this.contains(var0);
    }

    @Override
    public @Nullable IpBanListEntry get(SocketAddress var0) {
        String var1 = this.getIpFromAddress(var0);
        return (IpBanListEntry)this.get(var1);
    }

    private String getIpFromAddress(SocketAddress var0) {
        String var1 = var0.toString();
        if (var1.contains("/")) {
            var1 = var1.substring(var1.indexOf(47) + 1);
        }
        if (var1.contains(":")) {
            var1 = var1.substring(0, var1.indexOf(58));
        }
        return var1;
    }

    @Override
    public boolean add(IpBanListEntry var0) {
        if (super.add(var0)) {
            if (var0.getUser() != null) {
                this.notificationService.ipBanned(var0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String var0) {
        if (super.remove(var0)) {
            this.notificationService.ipUnbanned(var0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (IpBanListEntry var1 : this.getEntries()) {
            if (var1.getUser() == null) continue;
            this.notificationService.ipUnbanned((String)var1.getUser());
        }
        super.clear();
    }

    @Override
    public /* synthetic */ boolean remove(Object object) {
        return this.remove((String)object);
    }
}

