/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;

public class ServerOpListEntry
extends StoredUserEntry<NameAndId> {
    private final LevelBasedPermissionSet permissions;
    private final boolean bypassesPlayerLimit;

    public ServerOpListEntry(NameAndId var0, LevelBasedPermissionSet var1, boolean var2) {
        super(var0);
        this.permissions = var1;
        this.bypassesPlayerLimit = var2;
    }

    public ServerOpListEntry(JsonObject var0) {
        super(NameAndId.fromJson(var0));
        PermissionLevel var1 = var0.has("level") ? PermissionLevel.byId(var0.get("level").getAsInt()) : PermissionLevel.ALL;
        this.permissions = LevelBasedPermissionSet.forLevel(var1);
        this.bypassesPlayerLimit = var0.has("bypassesPlayerLimit") && var0.get("bypassesPlayerLimit").getAsBoolean();
    }

    public LevelBasedPermissionSet permissions() {
        return this.permissions;
    }

    public boolean getBypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    protected void serialize(JsonObject var0) {
        if (this.getUser() == null) {
            return;
        }
        ((NameAndId)this.getUser()).appendTo(var0);
        var0.addProperty("level", (Number)this.permissions.level().id());
        var0.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
    }
}

