/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.player.Player;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Cancellable;

public class StatsCounter {
    protected final Object2IntMap<Stat<?>> stats = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public StatsCounter() {
        this.stats.defaultReturnValue(0);
    }

    public void increment(Player entityhuman, Stat<?> statistic, int i) {
        int j = (int)Math.min((long)this.getValue(statistic) + (long)i, Integer.MAX_VALUE);
        Cancellable cancellable = CraftEventFactory.handleStatisticsIncrease(entityhuman, statistic, this.getValue(statistic), j);
        if (cancellable != null && cancellable.isCancelled()) {
            return;
        }
        this.setValue(entityhuman, statistic, j);
    }

    public void setValue(Player entityhuman, Stat<?> statistic, int i) {
        this.stats.put(statistic, i);
    }

    public <T> int getValue(StatType<T> statisticwrapper, T t0) {
        return statisticwrapper.contains(t0) ? this.getValue(statisticwrapper.get(t0)) : 0;
    }

    public int getValue(Stat<?> statistic) {
        return this.stats.getInt(statistic);
    }
}

