/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends Registry<?>>, NetworkPayload> serializeTagsToNetwork(LayeredRegistryAccess<RegistryLayer> var02) {
        return RegistrySynchronization.networkSafeRegistries(var02).map(var0 -> Pair.of(var0.key(), (Object)TagNetworkSerialization.serializeToNetwork(var0.value()))).filter(var0 -> !((NetworkPayload)var0.getSecond()).isEmpty()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> NetworkPayload serializeToNetwork(Registry<T> var0) {
        HashMap<Identifier, IntList> var1 = new HashMap<Identifier, IntList>();
        var0.getTags().forEach(var2 -> {
            IntArrayList var3 = new IntArrayList(var2.size());
            for (Holder var5 : var2) {
                if (var5.kind() != Holder.Kind.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + String.valueOf(var5));
                }
                var3.add(var0.getId(var5.value()));
            }
            var1.put(var2.key().location(), (IntList)var3);
        });
        return new NetworkPayload(var1);
    }

    static <T> TagLoader.LoadResult<T> deserializeTagsFromNetwork(Registry<T> var0, NetworkPayload var1) {
        ResourceKey var2 = var0.key();
        HashMap var32 = new HashMap();
        var1.tags.forEach((var3, var4) -> {
            TagKey var5 = TagKey.create(var2, var3);
            List var6 = var4.intStream().mapToObj(var0::get).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
            var32.put(var5, var6);
        });
        return new TagLoader.LoadResult<T>(var2, var32);
    }

    public static final class NetworkPayload {
        public static final NetworkPayload EMPTY = new NetworkPayload(Map.of());
        final Map<Identifier, IntList> tags;

        NetworkPayload(Map<Identifier, IntList> var0) {
            this.tags = var0;
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeMap(this.tags, FriendlyByteBuf::writeIdentifier, FriendlyByteBuf::writeIntIdList);
        }

        public static NetworkPayload read(FriendlyByteBuf var0) {
            return new NetworkPayload(var0.readMap(FriendlyByteBuf::readIdentifier, FriendlyByteBuf::readIntIdList));
        }

        public boolean isEmpty() {
            return this.tags.isEmpty();
        }

        public int size() {
            return this.tags.size();
        }

        public <T> TagLoader.LoadResult<T> resolve(Registry<T> var0) {
            return TagNetworkSerialization.deserializeTagsFromNetwork(var0, this);
        }
    }
}

