/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ARGB {
    private static final int LINEAR_CHANNEL_DEPTH = 1024;
    private static final short[] SRGB_TO_LINEAR = Util.make(new short[256], var0 -> {
        for (int var1 = 0; var1 < ((short[])var0).length; ++var1) {
            float var2 = (float)var1 / 255.0f;
            var0[var1] = (short)Math.round(ARGB.computeSrgbToLinear(var2) * 1023.0f);
        }
    });
    private static final byte[] LINEAR_TO_SRGB = Util.make(new byte[1024], var0 -> {
        for (int var1 = 0; var1 < ((byte[])var0).length; ++var1) {
            float var2 = (float)var1 / 1023.0f;
            var0[var1] = (byte)Math.round(ARGB.computeLinearToSrgb(var2) * 255.0f);
        }
    });

    private static float computeSrgbToLinear(float var0) {
        if (var0 >= 0.04045f) {
            return (float)Math.pow(((double)var0 + 0.055) / 1.055, 2.4);
        }
        return var0 / 12.92f;
    }

    private static float computeLinearToSrgb(float var0) {
        if (var0 >= 0.0031308f) {
            return (float)(1.055 * Math.pow(var0, 0.4166666666666667) - 0.055);
        }
        return 12.92f * var0;
    }

    public static float srgbToLinearChannel(int var0) {
        return (float)SRGB_TO_LINEAR[var0] / 1023.0f;
    }

    public static int linearToSrgbChannel(float var0) {
        return LINEAR_TO_SRGB[Mth.floor(var0 * 1023.0f)] & 0xFF;
    }

    public static int meanLinear(int var0, int var1, int var2, int var3) {
        return ARGB.color((ARGB.alpha(var0) + ARGB.alpha(var1) + ARGB.alpha(var2) + ARGB.alpha(var3)) / 4, ARGB.linearChannelMean(ARGB.red(var0), ARGB.red(var1), ARGB.red(var2), ARGB.red(var3)), ARGB.linearChannelMean(ARGB.green(var0), ARGB.green(var1), ARGB.green(var2), ARGB.green(var3)), ARGB.linearChannelMean(ARGB.blue(var0), ARGB.blue(var1), ARGB.blue(var2), ARGB.blue(var3)));
    }

    private static int linearChannelMean(int var0, int var1, int var2, int var3) {
        int var4 = (SRGB_TO_LINEAR[var0] + SRGB_TO_LINEAR[var1] + SRGB_TO_LINEAR[var2] + SRGB_TO_LINEAR[var3]) / 4;
        return LINEAR_TO_SRGB[var4] & 0xFF;
    }

    public static int alpha(int var0) {
        return var0 >>> 24;
    }

    public static int red(int var0) {
        return var0 >> 16 & 0xFF;
    }

    public static int green(int var0) {
        return var0 >> 8 & 0xFF;
    }

    public static int blue(int var0) {
        return var0 & 0xFF;
    }

    public static int color(int var0, int var1, int var2, int var3) {
        return (var0 & 0xFF) << 24 | (var1 & 0xFF) << 16 | (var2 & 0xFF) << 8 | var3 & 0xFF;
    }

    public static int color(int var0, int var1, int var2) {
        return ARGB.color(255, var0, var1, var2);
    }

    public static int color(Vec3 var0) {
        return ARGB.color(ARGB.as8BitChannel((float)var0.x()), ARGB.as8BitChannel((float)var0.y()), ARGB.as8BitChannel((float)var0.z()));
    }

    public static int multiply(int var0, int var1) {
        if (var0 == -1) {
            return var1;
        }
        if (var1 == -1) {
            return var0;
        }
        return ARGB.color(ARGB.alpha(var0) * ARGB.alpha(var1) / 255, ARGB.red(var0) * ARGB.red(var1) / 255, ARGB.green(var0) * ARGB.green(var1) / 255, ARGB.blue(var0) * ARGB.blue(var1) / 255);
    }

    public static int addRgb(int var0, int var1) {
        return ARGB.color(ARGB.alpha(var0), Math.min(ARGB.red(var0) + ARGB.red(var1), 255), Math.min(ARGB.green(var0) + ARGB.green(var1), 255), Math.min(ARGB.blue(var0) + ARGB.blue(var1), 255));
    }

    public static int subtractRgb(int var0, int var1) {
        return ARGB.color(ARGB.alpha(var0), Math.max(ARGB.red(var0) - ARGB.red(var1), 0), Math.max(ARGB.green(var0) - ARGB.green(var1), 0), Math.max(ARGB.blue(var0) - ARGB.blue(var1), 0));
    }

    public static int multiplyAlpha(int var0, float var1) {
        if (var0 == 0 || var1 <= 0.0f) {
            return 0;
        }
        if (var1 >= 1.0f) {
            return var0;
        }
        return ARGB.color(ARGB.alphaFloat(var0) * var1, var0);
    }

    public static int scaleRGB(int var0, float var1) {
        return ARGB.scaleRGB(var0, var1, var1, var1);
    }

    public static int scaleRGB(int var0, float var1, float var2, float var3) {
        return ARGB.color(ARGB.alpha(var0), Math.clamp((long)((int)((float)ARGB.red(var0) * var1)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(var0) * var2)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(var0) * var3)), 0, 255));
    }

    public static int scaleRGB(int var0, int var1) {
        return ARGB.color(ARGB.alpha(var0), Math.clamp((long)ARGB.red(var0) * (long)var1 / 255L, 0, 255), Math.clamp((long)ARGB.green(var0) * (long)var1 / 255L, 0, 255), Math.clamp((long)ARGB.blue(var0) * (long)var1 / 255L, 0, 255));
    }

    public static int greyscale(int var0) {
        int var1 = (int)((float)ARGB.red(var0) * 0.3f + (float)ARGB.green(var0) * 0.59f + (float)ARGB.blue(var0) * 0.11f);
        return ARGB.color(ARGB.alpha(var0), var1, var1, var1);
    }

    public static int alphaBlend(int var0, int var1) {
        int var2 = ARGB.alpha(var0);
        int var3 = ARGB.alpha(var1);
        if (var3 == 255) {
            return var1;
        }
        if (var3 == 0) {
            return var0;
        }
        int var4 = var3 + var2 * (255 - var3) / 255;
        return ARGB.color(var4, ARGB.alphaBlendChannel(var4, var3, ARGB.red(var0), ARGB.red(var1)), ARGB.alphaBlendChannel(var4, var3, ARGB.green(var0), ARGB.green(var1)), ARGB.alphaBlendChannel(var4, var3, ARGB.blue(var0), ARGB.blue(var1)));
    }

    private static int alphaBlendChannel(int var0, int var1, int var2, int var3) {
        return (var3 * var1 + var2 * (var0 - var1)) / var0;
    }

    public static int srgbLerp(float var0, int var1, int var2) {
        int var3 = Mth.lerpInt(var0, ARGB.alpha(var1), ARGB.alpha(var2));
        int var4 = Mth.lerpInt(var0, ARGB.red(var1), ARGB.red(var2));
        int var5 = Mth.lerpInt(var0, ARGB.green(var1), ARGB.green(var2));
        int var6 = Mth.lerpInt(var0, ARGB.blue(var1), ARGB.blue(var2));
        return ARGB.color(var3, var4, var5, var6);
    }

    public static int linearLerp(float var0, int var1, int var2) {
        return ARGB.color(Mth.lerpInt(var0, ARGB.alpha(var1), ARGB.alpha(var2)), LINEAR_TO_SRGB[Mth.lerpInt(var0, SRGB_TO_LINEAR[ARGB.red(var1)], SRGB_TO_LINEAR[ARGB.red(var2)])] & 0xFF, LINEAR_TO_SRGB[Mth.lerpInt(var0, SRGB_TO_LINEAR[ARGB.green(var1)], SRGB_TO_LINEAR[ARGB.green(var2)])] & 0xFF, LINEAR_TO_SRGB[Mth.lerpInt(var0, SRGB_TO_LINEAR[ARGB.blue(var1)], SRGB_TO_LINEAR[ARGB.blue(var2)])] & 0xFF);
    }

    public static int opaque(int var0) {
        return var0 | 0xFF000000;
    }

    public static int transparent(int var0) {
        return var0 & 0xFFFFFF;
    }

    public static int color(int var0, int var1) {
        return var0 << 24 | var1 & 0xFFFFFF;
    }

    public static int color(float var0, int var1) {
        return ARGB.as8BitChannel(var0) << 24 | var1 & 0xFFFFFF;
    }

    public static int white(float var0) {
        return ARGB.as8BitChannel(var0) << 24 | 0xFFFFFF;
    }

    public static int white(int var0) {
        return var0 << 24 | 0xFFFFFF;
    }

    public static int black(float var0) {
        return ARGB.as8BitChannel(var0) << 24;
    }

    public static int black(int var0) {
        return var0 << 24;
    }

    public static int colorFromFloat(float var0, float var1, float var2, float var3) {
        return ARGB.color(ARGB.as8BitChannel(var0), ARGB.as8BitChannel(var1), ARGB.as8BitChannel(var2), ARGB.as8BitChannel(var3));
    }

    public static Vector3f vector3fFromRGB24(int var0) {
        return new Vector3f(ARGB.redFloat(var0), ARGB.greenFloat(var0), ARGB.blueFloat(var0));
    }

    public static Vector4f vector4fFromARGB32(int var0) {
        return new Vector4f(ARGB.redFloat(var0), ARGB.greenFloat(var0), ARGB.blueFloat(var0), ARGB.alphaFloat(var0));
    }

    public static int average(int var0, int var1) {
        return ARGB.color((ARGB.alpha(var0) + ARGB.alpha(var1)) / 2, (ARGB.red(var0) + ARGB.red(var1)) / 2, (ARGB.green(var0) + ARGB.green(var1)) / 2, (ARGB.blue(var0) + ARGB.blue(var1)) / 2);
    }

    public static int as8BitChannel(float var0) {
        return Mth.floor(var0 * 255.0f);
    }

    public static float alphaFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.alpha(var0));
    }

    public static float redFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.red(var0));
    }

    public static float greenFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.green(var0));
    }

    public static float blueFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.blue(var0));
    }

    private static float from8BitChannel(int var0) {
        return (float)var0 / 255.0f;
    }

    public static int toABGR(int var0) {
        return var0 & 0xFF00FF00 | (var0 & 0xFF0000) >> 16 | (var0 & 0xFF) << 16;
    }

    public static int fromABGR(int var0) {
        return ARGB.toABGR(var0);
    }

    public static int setBrightness(int var0, float var1) {
        float var13;
        float var12;
        float var11;
        float var10;
        int var2 = ARGB.red(var0);
        int var3 = ARGB.green(var0);
        int var4 = ARGB.blue(var0);
        int var5 = ARGB.alpha(var0);
        int var6 = Math.max(Math.max(var2, var3), var4);
        int var7 = Math.min(Math.min(var2, var3), var4);
        float var8 = var6 - var7;
        float var9 = var6 != 0 ? var8 / (float)var6 : 0.0f;
        if (var9 == 0.0f) {
            var10 = 0.0f;
        } else {
            var11 = (float)(var6 - var2) / var8;
            var12 = (float)(var6 - var3) / var8;
            var13 = (float)(var6 - var4) / var8;
            var10 = var2 == var6 ? var13 - var12 : (var3 == var6 ? 2.0f + var11 - var13 : 4.0f + var12 - var11);
            if ((var10 /= 6.0f) < 0.0f) {
                var10 += 1.0f;
            }
        }
        if (var9 == 0.0f) {
            var3 = var4 = Math.round(var1 * 255.0f);
            var2 = var4;
            return ARGB.color(var5, var2, var3, var4);
        }
        var11 = (var10 - (float)Math.floor(var10)) * 6.0f;
        var12 = var11 - (float)Math.floor(var11);
        var13 = var1 * (1.0f - var9);
        float var14 = var1 * (1.0f - var9 * var12);
        float var15 = var1 * (1.0f - var9 * (1.0f - var12));
        switch ((int)var11) {
            case 0: {
                var2 = Math.round(var1 * 255.0f);
                var3 = Math.round(var15 * 255.0f);
                var4 = Math.round(var13 * 255.0f);
                break;
            }
            case 1: {
                var2 = Math.round(var14 * 255.0f);
                var3 = Math.round(var1 * 255.0f);
                var4 = Math.round(var13 * 255.0f);
                break;
            }
            case 2: {
                var2 = Math.round(var13 * 255.0f);
                var3 = Math.round(var1 * 255.0f);
                var4 = Math.round(var15 * 255.0f);
                break;
            }
            case 3: {
                var2 = Math.round(var13 * 255.0f);
                var3 = Math.round(var14 * 255.0f);
                var4 = Math.round(var1 * 255.0f);
                break;
            }
            case 4: {
                var2 = Math.round(var15 * 255.0f);
                var3 = Math.round(var13 * 255.0f);
                var4 = Math.round(var1 * 255.0f);
                break;
            }
            case 5: {
                var2 = Math.round(var1 * 255.0f);
                var3 = Math.round(var13 * 255.0f);
                var4 = Math.round(var14 * 255.0f);
            }
        }
        return ARGB.color(var5, var2, var3, var4);
    }
}

