/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.Util;

public class ExtraDataFixUtils {
    public static Dynamic<?> fixBlockPos(Dynamic<?> var0) {
        Optional var1 = var0.get("X").asNumber().result();
        Optional var2 = var0.get("Y").asNumber().result();
        Optional var3 = var0.get("Z").asNumber().result();
        if (var1.isEmpty() || var2.isEmpty() || var3.isEmpty()) {
            return var0;
        }
        return ExtraDataFixUtils.createBlockPos(var0, ((Number)var1.get()).intValue(), ((Number)var2.get()).intValue(), ((Number)var3.get()).intValue());
    }

    public static Dynamic<?> fixInlineBlockPos(Dynamic<?> var0, String var1, String var2, String var3, String var4) {
        Optional var5 = var0.get(var1).asNumber().result();
        Optional var6 = var0.get(var2).asNumber().result();
        Optional var7 = var0.get(var3).asNumber().result();
        if (var5.isEmpty() || var6.isEmpty() || var7.isEmpty()) {
            return var0;
        }
        return var0.remove(var1).remove(var2).remove(var3).set(var4, ExtraDataFixUtils.createBlockPos(var0, ((Number)var5.get()).intValue(), ((Number)var6.get()).intValue(), ((Number)var7.get()).intValue()));
    }

    public static Dynamic<?> createBlockPos(Dynamic<?> var0, int var1, int var2, int var3) {
        return var0.createIntList(IntStream.of(var1, var2, var3));
    }

    public static <T, R> Typed<R> cast(Type<R> var0, Typed<T> var1) {
        return new Typed(var0, var1.getOps(), var1.getValue());
    }

    public static <T> Typed<T> cast(Type<T> var0, Object var1, DynamicOps<?> var2) {
        return new Typed(var0, var2, var1);
    }

    public static Type<?> patchSubType(Type<?> var0, Type<?> var1, Type<?> var2) {
        return var0.all(ExtraDataFixUtils.typePatcher(var1, var2), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> var0, Type<B> var1) {
        RewriteResult var2 = RewriteResult.create((View)View.create((String)"Patcher", var0, var1, var02 -> var0 -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(var0, (RewriteResult)var2), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> chainAllFilters(Function<Typed<?>, Typed<?>> ... var0) {
        return var1 -> {
            for (Function var5 : var0) {
                var1 = (Typed)var5.apply(var1);
            }
            return var1;
        };
    }

    public static Dynamic<?> blockState(String var0, Map<String, String> var12) {
        Dynamic var2 = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag());
        Dynamic var3 = var2.set("Name", var2.createString(var0));
        if (!var12.isEmpty()) {
            var3 = var3.set("Properties", var2.createMap(var12.entrySet().stream().collect(Collectors.toMap(var1 -> var2.createString((String)var1.getKey()), var1 -> var2.createString((String)var1.getValue())))));
        }
        return var3;
    }

    public static Dynamic<?> blockState(String var0) {
        return ExtraDataFixUtils.blockState(var0, Map.of());
    }

    public static Dynamic<?> fixStringField(Dynamic<?> var0, String var1, UnaryOperator<String> var22) {
        return var0.update(var1, var2 -> (Dynamic)DataFixUtils.orElse((Optional)var2.asString().map((Function)var22).map(arg_0 -> ((Dynamic)var0).createString(arg_0)).result(), (Object)var2));
    }

    public static String dyeColorIdToName(int var0) {
        return switch (var0) {
            default -> "white";
            case 1 -> "orange";
            case 2 -> "magenta";
            case 3 -> "light_blue";
            case 4 -> "yellow";
            case 5 -> "lime";
            case 6 -> "pink";
            case 7 -> "gray";
            case 8 -> "light_gray";
            case 9 -> "cyan";
            case 10 -> "purple";
            case 11 -> "blue";
            case 12 -> "brown";
            case 13 -> "green";
            case 14 -> "red";
            case 15 -> "black";
        };
    }

    public static <T> Typed<?> readAndSet(Typed<?> var0, OpticFinder<T> var1, Dynamic<?> var2) {
        return var0.set(var1, Util.readTypedOrThrow(var1.type(), var2, true));
    }
}

