/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class InlineBlockPosFormatFix
extends DataFix {
    public InlineBlockPosFormatFix(Schema var0) {
        super(var0, false);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder<?> var02 = this.entityFinder("minecraft:vex");
        OpticFinder<?> var1 = this.entityFinder("minecraft:phantom");
        OpticFinder<?> var2 = this.entityFinder("minecraft:turtle");
        List<OpticFinder<?>> var3 = List.of(this.entityFinder("minecraft:item_frame"), this.entityFinder("minecraft:glow_item_frame"), this.entityFinder("minecraft:painting"), this.entityFinder("minecraft:leash_knot"));
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - player", this.getInputSchema().getType(References.PLAYER), var0 -> var0.update(DSL.remainderFinder(), this::fixPlayer)), (TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - entity", this.getInputSchema().getType(References.ENTITY), var4 -> {
            var4 = var4.update(DSL.remainderFinder(), this::fixLivingEntity).updateTyped(var02, var0 -> var0.update(DSL.remainderFinder(), this::fixVex)).updateTyped(var1, var0 -> var0.update(DSL.remainderFinder(), this::fixPhantom)).updateTyped(var2, var0 -> var0.update(DSL.remainderFinder(), this::fixTurtle));
            for (OpticFinder var6 : var3) {
                var4 = var4.updateTyped(var6, var0 -> var0.update(DSL.remainderFinder(), this::fixBlockAttached));
            }
            return var4;
        }));
    }

    private OpticFinder<?> entityFinder(String var0) {
        return DSL.namedChoice((String)var0, (Type)this.getInputSchema().getChoiceType(References.ENTITY, var0));
    }

    private Dynamic<?> fixPlayer(Dynamic<?> var0) {
        Optional var4;
        var0 = this.fixLivingEntity(var0);
        Optional var1 = var0.get("SpawnX").asNumber().result();
        Optional var2 = var0.get("SpawnY").asNumber().result();
        Optional var3 = var0.get("SpawnZ").asNumber().result();
        if (var1.isPresent() && var2.isPresent() && var3.isPresent()) {
            var4 = var0.createMap(Map.of(var0.createString("pos"), ExtraDataFixUtils.createBlockPos(var0, ((Number)var1.get()).intValue(), ((Number)var2.get()).intValue(), ((Number)var3.get()).intValue())));
            var4 = Dynamic.copyField(var0, (String)"SpawnAngle", (Dynamic)var4, (String)"angle");
            var4 = Dynamic.copyField(var0, (String)"SpawnDimension", (Dynamic)var4, (String)"dimension");
            var4 = Dynamic.copyField(var0, (String)"SpawnForced", (Dynamic)var4, (String)"forced");
            var0 = var0.remove("SpawnX").remove("SpawnY").remove("SpawnZ").remove("SpawnAngle").remove("SpawnDimension").remove("SpawnForced");
            var0 = var0.set("respawn", (Dynamic)var4);
        }
        if ((var4 = var0.get("enteredNetherPosition").result()).isPresent()) {
            var0 = var0.remove("enteredNetherPosition").set("entered_nether_pos", var0.createList(Stream.of(var0.createDouble(((Dynamic)var4.get()).get("x").asDouble(0.0)), var0.createDouble(((Dynamic)var4.get()).get("y").asDouble(0.0)), var0.createDouble(((Dynamic)var4.get()).get("z").asDouble(0.0)))));
        }
        return var0;
    }

    private Dynamic<?> fixLivingEntity(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixInlineBlockPos(var0, "SleepingX", "SleepingY", "SleepingZ", "sleeping_pos");
    }

    private Dynamic<?> fixVex(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixInlineBlockPos(var0.renameField("LifeTicks", "life_ticks"), "BoundX", "BoundY", "BoundZ", "bound_pos");
    }

    private Dynamic<?> fixPhantom(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixInlineBlockPos(var0.renameField("Size", "size"), "AX", "AY", "AZ", "anchor_pos");
    }

    private Dynamic<?> fixTurtle(Dynamic<?> var0) {
        var0 = var0.remove("TravelPosX").remove("TravelPosY").remove("TravelPosZ");
        var0 = ExtraDataFixUtils.fixInlineBlockPos(var0, "HomePosX", "HomePosY", "HomePosZ", "home_pos");
        return var0.renameField("HasEgg", "has_egg");
    }

    private Dynamic<?> fixBlockAttached(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixInlineBlockPos(var0, "TileX", "TileY", "TileZ", "block_pos");
    }
}

