/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema var0, boolean var1, String var2, DSL.TypeReference var3, String var4) {
        super(var0, var1);
        this.name = var2;
        this.type = var3;
        this.entityName = var4;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(this.type);
        Type var1 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type var2 = this.getOutputSchema().getType(this.type);
        OpticFinder var3 = DSL.namedChoice((String)this.entityName, (Type)var1);
        Type<?> var4 = ExtraDataFixUtils.patchSubType(var0, var0, var2);
        return this.fix(var0, var2, var4, var3);
    }

    private <S, T, A> TypeRewriteRule fix(Type<S> var0, Type<T> var1, Type<?> var2, OpticFinder<A> var32) {
        return this.fixTypeEverywhereTyped(this.name, var0, var1, var3 -> {
            if (var3.getOptional(var32).isEmpty()) {
                return ExtraDataFixUtils.cast(var1, var3);
            }
            Typed var4 = ExtraDataFixUtils.cast(var2, var3);
            return Util.writeAndReadTypedOrThrow(var4, var1, this::fix);
        });
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

