/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.References;

public class RedstoneWireConnectionsFix
extends DataFix {
    public RedstoneWireConnectionsFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema var02 = this.getInputSchema();
        return this.fixTypeEverywhereTyped("RedstoneConnectionsFix", var02.getType(References.BLOCK_STATE), var0 -> var0.update(DSL.remainderFinder(), this::updateRedstoneConnections));
    }

    private <T> Dynamic<T> updateRedstoneConnections(Dynamic<T> var02) {
        boolean var1 = var02.get("Name").asString().result().filter("minecraft:redstone_wire"::equals).isPresent();
        if (!var1) {
            return var02;
        }
        return var02.update("Properties", var0 -> {
            String var12 = var0.get("east").asString("none");
            String var2 = var0.get("west").asString("none");
            String var3 = var0.get("north").asString("none");
            String var4 = var0.get("south").asString("none");
            boolean var5 = RedstoneWireConnectionsFix.isConnected(var12) || RedstoneWireConnectionsFix.isConnected(var2);
            boolean var6 = RedstoneWireConnectionsFix.isConnected(var3) || RedstoneWireConnectionsFix.isConnected(var4);
            String var7 = !RedstoneWireConnectionsFix.isConnected(var12) && !var6 ? "side" : var12;
            String var8 = !RedstoneWireConnectionsFix.isConnected(var2) && !var6 ? "side" : var2;
            String var9 = !RedstoneWireConnectionsFix.isConnected(var3) && !var5 ? "side" : var3;
            String var10 = !RedstoneWireConnectionsFix.isConnected(var4) && !var5 ? "side" : var4;
            return var0.update("east", var1 -> var1.createString(var7)).update("west", var1 -> var1.createString(var8)).update("north", var1 -> var1.createString(var9)).update("south", var1 -> var1.createString(var10));
        });
    }

    private static boolean isConnected(String var0) {
        return !"none".equals(var0);
    }
}

