/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class RemoveBlockEntityTagFix
extends DataFix {
    private final Set<String> blockEntityIdsToDrop;

    public RemoveBlockEntityTagFix(Schema var0, Set<String> var1) {
        super(var0, true);
        this.blockEntityIdsToDrop = var1;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder var1 = var0.findField("tag");
        OpticFinder var2 = var1.type().findField("BlockEntityTag");
        Type var32 = this.getInputSchema().getType(References.ENTITY);
        OpticFinder var42 = DSL.namedChoice((String)"minecraft:falling_block", (Type)this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:falling_block"));
        OpticFinder var5 = var42.type().findField("TileEntityData");
        Type var6 = this.getInputSchema().getType(References.STRUCTURE);
        OpticFinder var7 = var6.findField("blocks");
        OpticFinder var8 = DSL.typeFinder((Type)((List.ListType)var7.type()).getElement());
        OpticFinder var9 = var8.type().findField("nbt");
        OpticFinder var10 = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("ItemRemoveBlockEntityTagFix", var0, var3 -> var3.updateTyped(var1, var2 -> this.removeBlockEntity((Typed<?>)var2, (OpticFinder<?>)var2, (OpticFinder<String>)var10, "BlockEntityTag"))), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("FallingBlockEntityRemoveBlockEntityTagFix", var32, var3 -> var3.updateTyped(var42, var2 -> this.removeBlockEntity((Typed<?>)var2, (OpticFinder<?>)var5, (OpticFinder<String>)var10, "TileEntityData"))), this.fixTypeEverywhereTyped("StructureRemoveBlockEntityTagFix", var6, var4 -> var4.updateTyped(var7, var3 -> var3.updateTyped(var8, var2 -> this.removeBlockEntity((Typed<?>)var2, (OpticFinder<?>)var9, (OpticFinder<String>)var10, "nbt")))), this.convertUnchecked("ItemRemoveBlockEntityTagFix - update block entity type", this.getInputSchema().getType(References.BLOCK_ENTITY), this.getOutputSchema().getType(References.BLOCK_ENTITY))});
    }

    private Typed<?> removeBlockEntity(Typed<?> var0, OpticFinder<?> var12, OpticFinder<String> var2, String var3) {
        Optional var4 = var0.getOptionalTyped(var12);
        if (var4.isEmpty()) {
            return var0;
        }
        String var5 = ((Typed)var4.get()).getOptional(var2).orElse("");
        if (!this.blockEntityIdsToDrop.contains(var5)) {
            return var0;
        }
        return Util.writeAndReadTypedOrThrow(var0, var0.getType(), var1 -> var1.remove(var3));
    }
}

