/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.List;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class SignTextStrictJsonFix
extends NamedEntityFix {
    private static final List<String> LINE_FIELDS = List.of("Text1", "Text2", "Text3", "Text4");

    public SignTextStrictJsonFix(Schema var0) {
        super(var0, false, "SignTextStrictJsonFix", References.BLOCK_ENTITY, "Sign");
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        for (String var2 : LINE_FIELDS) {
            OpticFinder var3 = var0.getType().findField(var2);
            OpticFinder var4 = DSL.typeFinder((Type)this.getInputSchema().getType(References.TEXT_COMPONENT));
            var0 = var0.updateTyped(var3, var1 -> var1.update(var4, var0 -> var0.mapSecond(LegacyComponentDataFixUtils::rewriteFromLenient)));
        }
        return var0;
    }
}

