/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import org.slf4j.Logger;

public class V99
extends Schema {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Map<String, String> ITEM_TO_BLOCKENTITY = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        var0.put("minecraft:furnace", "Furnace");
        var0.put("minecraft:lit_furnace", "Furnace");
        var0.put("minecraft:chest", "Chest");
        var0.put("minecraft:trapped_chest", "Chest");
        var0.put("minecraft:ender_chest", "EnderChest");
        var0.put("minecraft:jukebox", "RecordPlayer");
        var0.put("minecraft:dispenser", "Trap");
        var0.put("minecraft:dropper", "Dropper");
        var0.put("minecraft:sign", "Sign");
        var0.put("minecraft:mob_spawner", "MobSpawner");
        var0.put("minecraft:noteblock", "Music");
        var0.put("minecraft:brewing_stand", "Cauldron");
        var0.put("minecraft:enhanting_table", "EnchantTable");
        var0.put("minecraft:command_block", "CommandBlock");
        var0.put("minecraft:beacon", "Beacon");
        var0.put("minecraft:skull", "Skull");
        var0.put("minecraft:daylight_detector", "DLDetector");
        var0.put("minecraft:hopper", "Hopper");
        var0.put("minecraft:banner", "Banner");
        var0.put("minecraft:flower_pot", "FlowerPot");
        var0.put("minecraft:repeating_command_block", "CommandBlock");
        var0.put("minecraft:chain_command_block", "CommandBlock");
        var0.put("minecraft:standing_sign", "Sign");
        var0.put("minecraft:wall_sign", "Sign");
        var0.put("minecraft:piston_head", "Piston");
        var0.put("minecraft:daylight_detector_inverted", "DLDetector");
        var0.put("minecraft:unpowered_comparator", "Comparator");
        var0.put("minecraft:powered_comparator", "Comparator");
        var0.put("minecraft:wall_banner", "Banner");
        var0.put("minecraft:standing_banner", "Banner");
        var0.put("minecraft:structure_block", "Structure");
        var0.put("minecraft:end_portal", "Airportal");
        var0.put("minecraft:end_gateway", "EndGateway");
        var0.put("minecraft:shield", "Banner");
    });
    public static final Map<String, String> ITEM_TO_ENTITY = Map.of("minecraft:armor_stand", "ArmorStand", "minecraft:painting", "Painting");
    protected static final Hook.HookFunction ADD_NAMES = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> var0, T var1) {
            return V99.addNames(new Dynamic(var0, var1), ITEM_TO_BLOCKENTITY, ITEM_TO_ENTITY);
        }
    };

    public V99(int var0, Schema var1) {
        super(var0, var1);
    }

    protected static void registerThrowableProjectile(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(var0)));
    }

    protected static void registerMinecart(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0)));
    }

    protected static void registerInventory(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        var0.register((Map)var12, "Item", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)References.ITEM_STACK.in(var0)));
        var0.registerSimple((Map)var12, "XPOrb");
        V99.registerThrowableProjectile(var0, var12, "ThrownEgg");
        var0.registerSimple((Map)var12, "LeashKnot");
        var0.registerSimple((Map)var12, "Painting");
        var0.register((Map)var12, "Arrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(var0)));
        var0.register((Map)var12, "TippedArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(var0)));
        var0.register((Map)var12, "SpectralArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(var0)));
        V99.registerThrowableProjectile(var0, var12, "Snowball");
        V99.registerThrowableProjectile(var0, var12, "Fireball");
        V99.registerThrowableProjectile(var0, var12, "SmallFireball");
        V99.registerThrowableProjectile(var0, var12, "ThrownEnderpearl");
        var0.registerSimple((Map)var12, "EyeOfEnderSignal");
        var0.register((Map)var12, "ThrownPotion", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"Potion", (TypeTemplate)References.ITEM_STACK.in(var0)));
        V99.registerThrowableProjectile(var0, var12, "ThrownExpBottle");
        var0.register((Map)var12, "ItemFrame", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)References.ITEM_STACK.in(var0)));
        V99.registerThrowableProjectile(var0, var12, "WitherSkull");
        var0.registerSimple((Map)var12, "PrimedTnt");
        var0.register((Map)var12, "FallingSand", var1 -> DSL.optionalFields((String)"Block", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"TileEntityData", (TypeTemplate)References.BLOCK_ENTITY.in(var0)));
        var0.register((Map)var12, "FireworksRocketEntity", var1 -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)References.ITEM_STACK.in(var0)));
        var0.registerSimple((Map)var12, "Boat");
        var0.register((Map)var12, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))));
        V99.registerMinecart(var0, var12, "MinecartRideable");
        var0.register((Map)var12, "MinecartChest", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))));
        V99.registerMinecart(var0, var12, "MinecartFurnace");
        V99.registerMinecart(var0, var12, "MinecartTNT");
        var0.register((Map)var12, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (TypeTemplate)References.UNTAGGED_SPAWNER.in(var0)));
        var0.register((Map)var12, "MinecartHopper", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))));
        var0.register((Map)var12, "MinecartCommandBlock", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(var0), (String)"LastOutput", (TypeTemplate)References.TEXT_COMPONENT.in(var0)));
        var0.registerSimple((Map)var12, "ArmorStand");
        var0.registerSimple((Map)var12, "Creeper");
        var0.registerSimple((Map)var12, "Skeleton");
        var0.registerSimple((Map)var12, "Spider");
        var0.registerSimple((Map)var12, "Giant");
        var0.registerSimple((Map)var12, "Zombie");
        var0.registerSimple((Map)var12, "Slime");
        var0.registerSimple((Map)var12, "Ghast");
        var0.registerSimple((Map)var12, "PigZombie");
        var0.register((Map)var12, "Enderman", var1 -> DSL.optionalFields((String)"carried", (TypeTemplate)References.BLOCK_NAME.in(var0)));
        var0.registerSimple((Map)var12, "CaveSpider");
        var0.registerSimple((Map)var12, "Silverfish");
        var0.registerSimple((Map)var12, "Blaze");
        var0.registerSimple((Map)var12, "LavaSlime");
        var0.registerSimple((Map)var12, "EnderDragon");
        var0.registerSimple((Map)var12, "WitherBoss");
        var0.registerSimple((Map)var12, "Bat");
        var0.registerSimple((Map)var12, "Witch");
        var0.registerSimple((Map)var12, "Endermite");
        var0.registerSimple((Map)var12, "Guardian");
        var0.registerSimple((Map)var12, "Pig");
        var0.registerSimple((Map)var12, "Sheep");
        var0.registerSimple((Map)var12, "Cow");
        var0.registerSimple((Map)var12, "Chicken");
        var0.registerSimple((Map)var12, "Squid");
        var0.registerSimple((Map)var12, "Wolf");
        var0.registerSimple((Map)var12, "MushroomCow");
        var0.registerSimple((Map)var12, "SnowMan");
        var0.registerSimple((Map)var12, "Ozelot");
        var0.registerSimple((Map)var12, "VillagerGolem");
        var0.register((Map)var12, "EntityHorse", var1 -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0)), (String)"ArmorItem", (TypeTemplate)References.ITEM_STACK.in(var0), (String)"SaddleItem", (TypeTemplate)References.ITEM_STACK.in(var0)));
        var0.registerSimple((Map)var12, "Rabbit");
        var0.register((Map)var12, "Villager", var1 -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)References.VILLAGER_TRADE.in(var0)))));
        var0.registerSimple((Map)var12, "EnderCrystal");
        var0.register((Map)var12, "AreaEffectCloud", var1 -> DSL.optionalFields((String)"Particle", (TypeTemplate)References.PARTICLE.in(var0)));
        var0.registerSimple((Map)var12, "ShulkerBullet");
        var0.registerSimple((Map)var12, "DragonFireball");
        var0.registerSimple((Map)var12, "Shulker");
        return var12;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        V99.registerInventory(var0, var12, "Furnace");
        V99.registerInventory(var0, var12, "Chest");
        var0.registerSimple((Map)var12, "EnderChest");
        var0.register((Map)var12, "RecordPlayer", var1 -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)References.ITEM_STACK.in(var0)));
        V99.registerInventory(var0, var12, "Trap");
        V99.registerInventory(var0, var12, "Dropper");
        var0.register((Map)var12, "Sign", () -> V99.sign(var0));
        var0.register((Map)var12, "MobSpawner", var1 -> References.UNTAGGED_SPAWNER.in(var0));
        var0.registerSimple((Map)var12, "Music");
        var0.registerSimple((Map)var12, "Piston");
        V99.registerInventory(var0, var12, "Cauldron");
        var0.registerSimple((Map)var12, "EnchantTable");
        var0.registerSimple((Map)var12, "Airportal");
        var0.register((Map)var12, "Control", () -> DSL.optionalFields((String)"LastOutput", (TypeTemplate)References.TEXT_COMPONENT.in(var0)));
        var0.registerSimple((Map)var12, "Beacon");
        var0.register((Map)var12, "Skull", () -> DSL.optionalFields((String)"custom_name", (TypeTemplate)References.TEXT_COMPONENT.in(var0)));
        var0.registerSimple((Map)var12, "DLDetector");
        V99.registerInventory(var0, var12, "Hopper");
        var0.registerSimple((Map)var12, "Comparator");
        var0.register((Map)var12, "FlowerPot", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)References.ITEM_NAME.in(var0))));
        var0.register((Map)var12, "Banner", () -> DSL.optionalFields((String)"CustomName", (TypeTemplate)References.TEXT_COMPONENT.in(var0)));
        var0.registerSimple((Map)var12, "Structure");
        var0.registerSimple((Map)var12, "EndGateway");
        return var12;
    }

    public static TypeTemplate sign(Schema var0) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"Text1", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"Text2", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"Text3", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"Text4", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"FilteredText1", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"FilteredText2", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"FilteredText3", (Object)References.TEXT_COMPONENT.in(var0)), Pair.of((Object)"FilteredText4", (Object)References.TEXT_COMPONENT.in(var0))});
    }

    public void registerTypes(Schema var0, Map<String, Supplier<TypeTemplate>> var1, Map<String, Supplier<TypeTemplate>> var2) {
        var0.registerType(false, References.LEVEL, () -> DSL.optionalFields((String)"CustomBossEvents", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(var0))), (TypeTemplate)References.LIGHTWEIGHT_LEVEL.in(var0)));
        var0.registerType(false, References.LIGHTWEIGHT_LEVEL, DSL::remainder);
        var0.registerType(false, References.PLAYER, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))));
        var0.registerType(false, References.CHUNK, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.ENTITY_TREE.in(var0)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)References.BLOCK_ENTITY.in(var0), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)References.BLOCK_NAME.in(var0))))));
        var0.registerType(true, References.BLOCK_ENTITY, () -> DSL.optionalFields((String)"components", (TypeTemplate)References.DATA_COMPONENTS.in(var0), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var2)));
        var0.registerType(true, References.ENTITY_TREE, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)References.ENTITY_TREE.in(var0), (TypeTemplate)References.ENTITY.in(var0)));
        var0.registerType(false, References.ENTITY_NAME, () -> DSL.constType(NamespacedSchema.namespacedString()));
        var0.registerType(true, References.ENTITY, () -> DSL.and((TypeTemplate)References.ENTITY_EQUIPMENT.in(var0), (TypeTemplate)DSL.optionalFields((String)"CustomName", (TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var1))));
        var0.registerType(true, References.ITEM_STACK, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)References.ITEM_NAME.in(var0)), (String)"tag", (TypeTemplate)V99.itemStackTag(var0)), (Hook.HookFunction)ADD_NAMES, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        var0.registerType(false, References.OPTIONS, DSL::remainder);
        var0.registerType(false, References.BLOCK_NAME, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType(NamespacedSchema.namespacedString())));
        var0.registerType(false, References.ITEM_NAME, () -> DSL.constType(NamespacedSchema.namespacedString()));
        var0.registerType(false, References.STATS, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_COMMAND_STORAGE, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_TICKETS, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_MAP_DATA, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"banners", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(var0))))));
        var0.registerType(false, References.SAVED_DATA_MAP_INDEX, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_RAIDS, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_RANDOM_SEQUENCES, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_SCOREBOARD, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)References.OBJECTIVE.in(var0)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)References.TEAM.in(var0)), (String)"PlayerScores", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"display", (TypeTemplate)References.TEXT_COMPONENT.in(var0))))));
        var0.registerType(false, References.SAVED_DATA_STOPWATCHES, DSL::remainder);
        var0.registerType(false, References.SAVED_DATA_STRUCTURE_FEATURE_INDICES, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)References.STRUCTURE_FEATURE.in(var0)))));
        var0.registerType(false, References.SAVED_DATA_WORLD_BORDER, DSL::remainder);
        var0.registerType(false, References.DEBUG_PROFILE, DSL::remainder);
        var0.registerType(false, References.STRUCTURE_FEATURE, DSL::remainder);
        var0.registerType(false, References.OBJECTIVE, DSL::remainder);
        var0.registerType(false, References.TEAM, () -> DSL.optionalFields((String)"MemberNamePrefix", (TypeTemplate)References.TEXT_COMPONENT.in(var0), (String)"MemberNameSuffix", (TypeTemplate)References.TEXT_COMPONENT.in(var0), (String)"DisplayName", (TypeTemplate)References.TEXT_COMPONENT.in(var0)));
        var0.registerType(true, References.UNTAGGED_SPAWNER, DSL::remainder);
        var0.registerType(false, References.POI_CHUNK, DSL::remainder);
        var0.registerType(false, References.WORLD_GEN_SETTINGS, DSL::remainder);
        var0.registerType(false, References.ENTITY_CHUNK, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.ENTITY_TREE.in(var0))));
        var0.registerType(true, References.DATA_COMPONENTS, DSL::remainder);
        var0.registerType(true, References.VILLAGER_TRADE, () -> DSL.optionalFields((String)"buy", (TypeTemplate)References.ITEM_STACK.in(var0), (String)"buyB", (TypeTemplate)References.ITEM_STACK.in(var0), (String)"sell", (TypeTemplate)References.ITEM_STACK.in(var0)));
        var0.registerType(true, References.PARTICLE, () -> DSL.constType((Type)DSL.string()));
        var0.registerType(true, References.TEXT_COMPONENT, () -> DSL.constType((Type)DSL.string()));
        var0.registerType(false, References.STRUCTURE, () -> DSL.optionalFields((String)"entities", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)References.ENTITY_TREE.in(var0))), (String)"blocks", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)References.BLOCK_ENTITY.in(var0))), (String)"palette", (TypeTemplate)DSL.list((TypeTemplate)References.BLOCK_STATE.in(var0))));
        var0.registerType(false, References.BLOCK_STATE, DSL::remainder);
        var0.registerType(false, References.FLAT_BLOCK_STATE, DSL::remainder);
        var0.registerType(true, References.ENTITY_EQUIPMENT, () -> DSL.optional((TypeTemplate)DSL.field((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0)))));
    }

    public static TypeTemplate itemStackTag(Schema var0) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)References.ENTITY_TREE.in(var0)), Pair.of((Object)"BlockEntityTag", (Object)References.BLOCK_ENTITY.in(var0)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)References.BLOCK_NAME.in(var0))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)References.BLOCK_NAME.in(var0))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)References.ITEM_STACK.in(var0))), Pair.of((Object)"pages", (Object)DSL.list((TypeTemplate)References.TEXT_COMPONENT.in(var0))), Pair.of((Object)"filtered_pages", (Object)DSL.compoundList((TypeTemplate)References.TEXT_COMPONENT.in(var0))), Pair.of((Object)"display", (Object)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(var0), (String)"Lore", (TypeTemplate)DSL.list((TypeTemplate)References.TEXT_COMPONENT.in(var0))))});
    }

    protected static <T> T addNames(Dynamic<T> var0, Map<String, String> var1, Map<String, String> var2) {
        return (T)var0.update("tag", var3 -> var3.update("BlockEntityTag", var2 -> {
            Object var3 = var0.get("id").asString().result().map(NamespacedSchema::ensureNamespaced).orElse("minecraft:air");
            if (!"minecraft:air".equals(var3)) {
                String var4 = (String)var1.get(var3);
                if (var4 == null) {
                    LOGGER.warn("Unable to resolve BlockEntity for ItemStack: {}", var3);
                } else {
                    return var2.set("id", var0.createString(var4));
                }
            }
            return var2;
        }).update("EntityTag", var2 -> {
            if (var2.get("id").result().isPresent()) {
                return var2;
            }
            Object var3 = NamespacedSchema.ensureNamespaced(var0.get("id").asString(""));
            String var4 = (String)var2.get(var3);
            if (var4 != null) {
                return var2.set("id", var0.createString(var4));
            }
            return var2;
        })).getValue();
    }
}

