/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundDebugBlockValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugChunkValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEntityValuePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import org.jspecify.annotations.Nullable;

public abstract class TrackingDebugSynchronizer<T> {
    protected final DebugSubscription<T> subscription;
    private final Set<UUID> subscribedPlayers = new ObjectOpenHashSet();

    public TrackingDebugSynchronizer(DebugSubscription<T> var0) {
        this.subscription = var0;
    }

    public final void tick(ServerLevel var0) {
        for (ServerPlayer var2 : var0.players()) {
            boolean var3 = this.subscribedPlayers.contains(var2.getUUID());
            boolean var4 = var2.debugSubscriptions().contains(this.subscription);
            if (var4 == var3) continue;
            if (var4) {
                this.addSubscriber(var2);
                continue;
            }
            this.subscribedPlayers.remove(var2.getUUID());
        }
        this.subscribedPlayers.removeIf(var1 -> var0.getPlayerByUUID((UUID)var1) == null);
        if (!this.subscribedPlayers.isEmpty()) {
            this.pollAndSendUpdates(var0);
        }
    }

    private void addSubscriber(ServerPlayer var0) {
        this.subscribedPlayers.add(var0.getUUID());
        var0.getChunkTrackingView().forEach(var1 -> {
            if (!var0.connection.chunkSender.isPending(var1.toLong())) {
                this.startTrackingChunk(var0, (ChunkPos)var1);
            }
        });
        var0.level().getChunkSource().chunkMap.forEachEntityTrackedBy(var0, var1 -> this.startTrackingEntity(var0, (Entity)var1));
    }

    protected final void sendToPlayersTrackingChunk(ServerLevel var0, ChunkPos var1, Packet<? super ClientGamePacketListener> var2) {
        ChunkMap var3 = var0.getChunkSource().chunkMap;
        for (UUID var5 : this.subscribedPlayers) {
            ServerPlayer var6;
            Player player = var0.getPlayerByUUID(var5);
            if (!(player instanceof ServerPlayer) || !var3.isChunkTracked(var6 = (ServerPlayer)player, var1.x, var1.z)) continue;
            var6.connection.send(var2);
        }
    }

    protected final void sendToPlayersTrackingEntity(ServerLevel var02, Entity var1, Packet<? super ClientGamePacketListener> var2) {
        ChunkMap var3 = var02.getChunkSource().chunkMap;
        var3.sendToTrackingPlayersFiltered(var1, var2, var0 -> this.subscribedPlayers.contains(var0.getUUID()));
    }

    public final void startTrackingChunk(ServerPlayer var0, ChunkPos var1) {
        if (this.subscribedPlayers.contains(var0.getUUID())) {
            this.sendInitialChunk(var0, var1);
        }
    }

    public final void startTrackingEntity(ServerPlayer var0, Entity var1) {
        if (this.subscribedPlayers.contains(var0.getUUID())) {
            this.sendInitialEntity(var0, var1);
        }
    }

    protected void clear() {
    }

    protected void pollAndSendUpdates(ServerLevel var0) {
    }

    protected void sendInitialChunk(ServerPlayer var0, ChunkPos var1) {
    }

    protected void sendInitialEntity(ServerPlayer var0, Entity var1) {
    }

    public static class VillageSectionSynchronizer
    extends TrackingDebugSynchronizer<Unit> {
        public VillageSectionSynchronizer() {
            super(DebugSubscriptions.VILLAGE_SECTIONS);
        }

        @Override
        protected void sendInitialChunk(ServerPlayer var02, ChunkPos var1) {
            ServerLevel var2 = var02.level();
            PoiManager var3 = var2.getPoiManager();
            var3.getInChunk(var0 -> true, var1, PoiManager.Occupancy.ANY).forEach(var22 -> {
                SectionPos var3 = SectionPos.of(var22.getPos());
                VillageSectionSynchronizer.forEachVillageSectionUpdate(var2, var3, (var1, var2) -> {
                    BlockPos var3 = var1.center();
                    var0.connection.send(new ClientboundDebugBlockValuePacket(var3, this.subscription.packUpdate(var2 != false ? Unit.INSTANCE : null)));
                });
            });
        }

        public void onPoiAdded(ServerLevel var0, PoiRecord var1) {
            this.sendVillageSectionsPacket(var0, var1.getPos());
        }

        public void onPoiRemoved(ServerLevel var0, BlockPos var1) {
            this.sendVillageSectionsPacket(var0, var1);
        }

        private void sendVillageSectionsPacket(ServerLevel var0, BlockPos var12) {
            VillageSectionSynchronizer.forEachVillageSectionUpdate(var0, SectionPos.of(var12), (var1, var2) -> {
                BlockPos var3 = var1.center();
                if (var2.booleanValue()) {
                    this.sendToPlayersTrackingChunk(var0, new ChunkPos(var3), new ClientboundDebugBlockValuePacket(var3, this.subscription.packUpdate(Unit.INSTANCE)));
                } else {
                    this.sendToPlayersTrackingChunk(var0, new ChunkPos(var3), new ClientboundDebugBlockValuePacket(var3, this.subscription.emptyUpdate()));
                }
            });
        }

        private static void forEachVillageSectionUpdate(ServerLevel var0, SectionPos var1, BiConsumer<SectionPos, Boolean> var2) {
            for (int var3 = -1; var3 <= 1; ++var3) {
                for (int var4 = -1; var4 <= 1; ++var4) {
                    for (int var5 = -1; var5 <= 1; ++var5) {
                        SectionPos var6 = var1.offset(var4, var5, var3);
                        if (var0.isVillage(var6.center())) {
                            var2.accept(var6, true);
                            continue;
                        }
                        var2.accept(var6, false);
                    }
                }
            }
        }
    }

    public static class PoiSynchronizer
    extends TrackingDebugSynchronizer<DebugPoiInfo> {
        public PoiSynchronizer() {
            super(DebugSubscriptions.POIS);
        }

        @Override
        protected void sendInitialChunk(ServerPlayer var02, ChunkPos var12) {
            ServerLevel var2 = var02.level();
            PoiManager var3 = var2.getPoiManager();
            var3.getInChunk(var0 -> true, var12, PoiManager.Occupancy.ANY).forEach(var1 -> var0.connection.send(new ClientboundDebugBlockValuePacket(var1.getPos(), this.subscription.packUpdate(new DebugPoiInfo((PoiRecord)var1)))));
        }

        public void onPoiAdded(ServerLevel var0, PoiRecord var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkPos(var1.getPos()), new ClientboundDebugBlockValuePacket(var1.getPos(), this.subscription.packUpdate(new DebugPoiInfo(var1))));
        }

        public void onPoiRemoved(ServerLevel var0, BlockPos var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkPos(var1), new ClientboundDebugBlockValuePacket(var1, this.subscription.emptyUpdate()));
        }

        public void onPoiTicketCountChanged(ServerLevel var0, BlockPos var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkPos(var1), new ClientboundDebugBlockValuePacket(var1, this.subscription.packUpdate(var0.getPoiManager().getDebugPoiInfo(var1))));
        }
    }

    static class ValueSource<T> {
        private final DebugValueSource.ValueGetter<T> getter;
        @Nullable T lastSyncedValue;

        ValueSource(DebugValueSource.ValueGetter<T> var0) {
            this.getter = var0;
        }

        public @Nullable DebugSubscription.Update<T> pollUpdate(DebugSubscription<T> var0) {
            T var1 = this.getter.get();
            if (!Objects.equals(var1, this.lastSyncedValue)) {
                this.lastSyncedValue = var1;
                return var0.packUpdate(var1);
            }
            return null;
        }
    }

    public static class SourceSynchronizer<T>
    extends TrackingDebugSynchronizer<T> {
        private final Map<ChunkPos, ValueSource<T>> chunkSources = new HashMap<ChunkPos, ValueSource<T>>();
        private final Map<BlockPos, ValueSource<T>> blockEntitySources = new HashMap<BlockPos, ValueSource<T>>();
        private final Map<UUID, ValueSource<T>> entitySources = new HashMap<UUID, ValueSource<T>>();

        public SourceSynchronizer(DebugSubscription<T> var0) {
            super(var0);
        }

        @Override
        protected void clear() {
            this.chunkSources.clear();
            this.blockEntitySources.clear();
            this.entitySources.clear();
        }

        @Override
        protected void pollAndSendUpdates(ServerLevel var0) {
            Object var4;
            DebugSubscription.Update<T> var3;
            for (Map.Entry<ChunkPos, ValueSource<T>> entry : this.chunkSources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = entry.getKey();
                this.sendToPlayersTrackingChunk(var0, (ChunkPos)var4, new ClientboundDebugChunkValuePacket((ChunkPos)var4, var3));
            }
            for (Map.Entry<Object, ValueSource<T>> entry : this.blockEntitySources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = (BlockPos)entry.getKey();
                ChunkPos var5 = new ChunkPos((BlockPos)var4);
                this.sendToPlayersTrackingChunk(var0, var5, new ClientboundDebugBlockValuePacket((BlockPos)var4, var3));
            }
            for (Map.Entry<Object, ValueSource<T>> entry : this.entitySources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = Objects.requireNonNull(var0.getEntity((UUID)entry.getKey()));
                this.sendToPlayersTrackingEntity(var0, (Entity)var4, new ClientboundDebugEntityValuePacket(((Entity)var4).getId(), var3));
            }
        }

        public void registerChunk(ChunkPos var0, DebugValueSource.ValueGetter<T> var1) {
            this.chunkSources.put(var0, new ValueSource<T>(var1));
        }

        public void registerBlockEntity(BlockPos var0, DebugValueSource.ValueGetter<T> var1) {
            this.blockEntitySources.put(var0, new ValueSource<T>(var1));
        }

        public void registerEntity(UUID var0, DebugValueSource.ValueGetter<T> var1) {
            this.entitySources.put(var0, new ValueSource<T>(var1));
        }

        public void dropChunk(ChunkPos var0) {
            this.chunkSources.remove(var0);
            this.blockEntitySources.keySet().removeIf(var0::contains);
        }

        public void dropBlockEntity(ServerLevel var0, BlockPos var1) {
            ValueSource<T> var2 = this.blockEntitySources.remove(var1);
            if (var2 != null) {
                ChunkPos var3 = new ChunkPos(var1);
                this.sendToPlayersTrackingChunk(var0, var3, new ClientboundDebugBlockValuePacket(var1, this.subscription.emptyUpdate()));
            }
        }

        public void dropEntity(Entity var0) {
            this.entitySources.remove(var0.getUUID());
        }

        @Override
        protected void sendInitialChunk(ServerPlayer var0, ChunkPos var1) {
            ValueSource<T> var2 = this.chunkSources.get(var1);
            if (var2 != null && var2.lastSyncedValue != null) {
                var0.connection.send(new ClientboundDebugChunkValuePacket(var1, this.subscription.packUpdate(var2.lastSyncedValue)));
            }
            for (Map.Entry<BlockPos, ValueSource<T>> var4 : this.blockEntitySources.entrySet()) {
                BlockPos var6;
                Object var5 = var4.getValue().lastSyncedValue;
                if (var5 == null || !var1.contains(var6 = var4.getKey())) continue;
                var0.connection.send(new ClientboundDebugBlockValuePacket(var6, this.subscription.packUpdate(var5)));
            }
        }

        @Override
        protected void sendInitialEntity(ServerPlayer var0, Entity var1) {
            ValueSource<T> var2 = this.entitySources.get(var1.getUUID());
            if (var2 != null && var2.lastSyncedValue != null) {
                var0.connection.send(new ClientboundDebugEntityValuePacket(var1.getId(), this.subscription.packUpdate(var2.lastSyncedValue)));
            }
        }
    }
}

