/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import org.jspecify.annotations.Nullable;

public interface Rule<S, T> {
    public @Nullable T parse(ParseState<S> var1);

    public static <S, T> Rule<S, T> fromTerm(Term<S> var0, RuleAction<S, T> var1) {
        return new WrappedTerm<S, T>(var1, var0);
    }

    public static <S, T> Rule<S, T> fromTerm(Term<S> var0, SimpleRuleAction<S, T> var1) {
        return new WrappedTerm<S, T>(var1, var0);
    }

    public record WrappedTerm<S, T>(RuleAction<S, T> action, Term<S> child) implements Rule<S, T>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable T parse(ParseState<S> var0) {
            Scope var1 = var0.scope();
            var1.pushFrame();
            try {
                if (this.child.parse(var0, var1, Control.UNBOUND)) {
                    T t = this.action.run(var0);
                    return t;
                }
                T t = null;
                return t;
            }
            finally {
                var1.popFrame();
            }
        }
    }

    @FunctionalInterface
    public static interface RuleAction<S, T> {
        public @Nullable T run(ParseState<S> var1);
    }

    @FunctionalInterface
    public static interface SimpleRuleAction<S, T>
    extends RuleAction<S, T> {
        public T run(Scope var1);

        @Override
        default public T run(ParseState<S> var0) {
            return this.run(var0.scope());
        }
    }
}

