/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Util;
import net.minecraft.util.parsing.packrat.Atom;
import org.jspecify.annotations.Nullable;

public final class Scope {
    private static final int NOT_FOUND = -1;
    private static final Object FRAME_START_MARKER = new Object(){

        public String toString() {
            return "frame";
        }
    };
    private static final int ENTRY_STRIDE = 2;
    private @Nullable Object[] stack = new Object[128];
    private int topEntryKeyIndex = 0;
    private int topMarkerKeyIndex = 0;

    public Scope() {
        this.stack[0] = FRAME_START_MARKER;
        this.stack[1] = null;
    }

    private int valueIndex(Atom<?> var0) {
        for (int var1 = this.topEntryKeyIndex; var1 > this.topMarkerKeyIndex; var1 -= 2) {
            Object var2 = this.stack[var1];
            assert (var2 instanceof Atom);
            if (var2 != var0) continue;
            return var1 + 1;
        }
        return -1;
    }

    public int valueIndexForAny(Atom<?> ... var0) {
        for (int var1 = this.topEntryKeyIndex; var1 > this.topMarkerKeyIndex; var1 -= 2) {
            Object var2 = this.stack[var1];
            assert (var2 instanceof Atom);
            for (Atom<?> var6 : var0) {
                if (var6 != var2) continue;
                return var1 + 1;
            }
        }
        return -1;
    }

    private void ensureCapacity(int var0) {
        int var2 = this.topEntryKeyIndex + 1;
        int var3 = var2 + var0 * 2;
        int var1 = this.stack.length;
        if (var3 >= var1) {
            int var4 = Util.growByHalf(var1, var3 + 1);
            Object[] var5 = new Object[var4];
            System.arraycopy(this.stack, 0, var5, 0, var1);
            this.stack = var5;
        }
        assert (this.validateStructure());
    }

    private void setupNewFrame() {
        this.topEntryKeyIndex += 2;
        this.stack[this.topEntryKeyIndex] = FRAME_START_MARKER;
        this.stack[this.topEntryKeyIndex + 1] = this.topMarkerKeyIndex;
        this.topMarkerKeyIndex = this.topEntryKeyIndex;
    }

    public void pushFrame() {
        this.ensureCapacity(1);
        this.setupNewFrame();
        assert (this.validateStructure());
    }

    private int getPreviousMarkerIndex(int var0) {
        return (Integer)this.stack[var0 + 1];
    }

    public void popFrame() {
        assert (this.topMarkerKeyIndex != 0);
        this.topEntryKeyIndex = this.topMarkerKeyIndex - 2;
        this.topMarkerKeyIndex = this.getPreviousMarkerIndex(this.topMarkerKeyIndex);
        assert (this.validateStructure());
    }

    public void splitFrame() {
        int var0 = this.topMarkerKeyIndex;
        int var1 = (this.topEntryKeyIndex - this.topMarkerKeyIndex) / 2;
        this.ensureCapacity(var1 + 1);
        this.setupNewFrame();
        int var2 = var0 + 2;
        int var3 = this.topEntryKeyIndex;
        for (int var4 = 0; var4 < var1; ++var4) {
            var3 += 2;
            Object var5 = this.stack[var2];
            assert (var5 != null);
            this.stack[var3] = var5;
            this.stack[var3 + 1] = null;
            var2 += 2;
        }
        this.topEntryKeyIndex = var3;
        assert (this.validateStructure());
    }

    public void clearFrameValues() {
        for (int var0 = this.topEntryKeyIndex; var0 > this.topMarkerKeyIndex; var0 -= 2) {
            assert (this.stack[var0] instanceof Atom);
            this.stack[var0 + 1] = null;
        }
        assert (this.validateStructure());
    }

    public void mergeFrame() {
        int var0;
        int var1 = var0 = this.getPreviousMarkerIndex(this.topMarkerKeyIndex);
        int var2 = this.topMarkerKeyIndex;
        while (var2 < this.topEntryKeyIndex) {
            var1 += 2;
            Object var3 = this.stack[var2 += 2];
            assert (var3 instanceof Atom);
            Object var4 = this.stack[var2 + 1];
            Object var5 = this.stack[var1];
            if (var5 != var3) {
                this.stack[var1] = var3;
                this.stack[var1 + 1] = var4;
                continue;
            }
            if (var4 == null) continue;
            this.stack[var1 + 1] = var4;
        }
        this.topEntryKeyIndex = var1;
        this.topMarkerKeyIndex = var0;
        assert (this.validateStructure());
    }

    public <T> void put(Atom<T> var0, @Nullable T var1) {
        int var2 = this.valueIndex(var0);
        if (var2 != -1) {
            this.stack[var2] = var1;
        } else {
            this.ensureCapacity(1);
            this.topEntryKeyIndex += 2;
            this.stack[this.topEntryKeyIndex] = var0;
            this.stack[this.topEntryKeyIndex + 1] = var1;
        }
        assert (this.validateStructure());
    }

    public <T> @Nullable T get(Atom<T> var0) {
        int var1 = this.valueIndex(var0);
        return (T)(var1 != -1 ? this.stack[var1] : null);
    }

    public <T> T getOrThrow(Atom<T> var0) {
        int var1 = this.valueIndex(var0);
        if (var1 == -1) {
            throw new IllegalArgumentException("No value for atom " + String.valueOf(var0));
        }
        return (T)this.stack[var1];
    }

    public <T> T getOrDefault(Atom<T> var0, T var1) {
        int var2 = this.valueIndex(var0);
        return (T)(var2 != -1 ? this.stack[var2] : var1);
    }

    @SafeVarargs
    public final <T> @Nullable T getAny(Atom<? extends T> ... var0) {
        int var1 = this.valueIndexForAny(var0);
        return (T)(var1 != -1 ? this.stack[var1] : null);
    }

    @SafeVarargs
    public final <T> T getAnyOrThrow(Atom<? extends T> ... var0) {
        int var1 = this.valueIndexForAny(var0);
        if (var1 == -1) {
            throw new IllegalArgumentException("No value for atoms " + Arrays.toString(var0));
        }
        return (T)this.stack[var1];
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        boolean var1 = true;
        for (int var2 = 0; var2 <= this.topEntryKeyIndex; var2 += 2) {
            Object var3 = this.stack[var2];
            Object var4 = this.stack[var2 + 1];
            if (var3 == FRAME_START_MARKER) {
                var0.append('|');
                var1 = true;
                continue;
            }
            if (!var1) {
                var0.append(',');
            }
            var1 = false;
            var0.append(var3).append(':').append(var4);
        }
        return var0.toString();
    }

    @VisibleForTesting
    public Map<Atom<?>, ?> lastFrame() {
        HashMap<Atom, Object> var0 = new HashMap<Atom, Object>();
        for (int var1 = this.topEntryKeyIndex; var1 > this.topMarkerKeyIndex; var1 -= 2) {
            Object var2 = this.stack[var1];
            Object var3 = this.stack[var1 + 1];
            var0.put((Atom)var2, var3);
        }
        return var0;
    }

    public boolean hasOnlySingleFrame() {
        for (int var0 = this.topEntryKeyIndex; var0 > 0; --var0) {
            if (this.stack[var0] != FRAME_START_MARKER) continue;
            return false;
        }
        if (this.stack[0] != FRAME_START_MARKER) {
            throw new IllegalStateException("Corrupted stack");
        }
        return true;
    }

    private boolean validateStructure() {
        Object var1;
        int var0;
        assert (this.topMarkerKeyIndex >= 0);
        assert (this.topEntryKeyIndex >= this.topMarkerKeyIndex);
        for (var0 = 0; var0 <= this.topEntryKeyIndex; var0 += 2) {
            var1 = this.stack[var0];
            if (var1 == FRAME_START_MARKER || var1 instanceof Atom) continue;
            return false;
        }
        var0 = this.topMarkerKeyIndex;
        while (var0 != 0) {
            var1 = this.stack[var0];
            if (var1 != FRAME_START_MARKER) {
                return false;
            }
            var0 = this.getPreviousMarkerIndex(var0);
        }
        return true;
    }
}

