/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.Supplier;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.util.profiling.metrics.MetricCategory;

public interface ProfilerFiller {
    public static final String ROOT = "root";

    public void startTick();

    public void endTick();

    public void push(String var1);

    public void push(Supplier<String> var1);

    public void pop();

    public void popPush(String var1);

    public void popPush(Supplier<String> var1);

    default public void addZoneText(String var0) {
    }

    default public void addZoneValue(long var0) {
    }

    default public void setZoneColor(int var0) {
    }

    default public Zone zone(String var0) {
        this.push(var0);
        return new Zone(this);
    }

    default public Zone zone(Supplier<String> var0) {
        this.push(var0);
        return new Zone(this);
    }

    public void markForCharting(MetricCategory var1);

    default public void incrementCounter(String var0) {
        this.incrementCounter(var0, 1);
    }

    public void incrementCounter(String var1, int var2);

    default public void incrementCounter(Supplier<String> var0) {
        this.incrementCounter(var0, 1);
    }

    public void incrementCounter(Supplier<String> var1, int var2);

    public static ProfilerFiller combine(ProfilerFiller var0, ProfilerFiller var1) {
        if (var0 == InactiveProfiler.INSTANCE) {
            return var1;
        }
        if (var1 == InactiveProfiler.INSTANCE) {
            return var0;
        }
        return new CombinedProfileFiller(var0, var1);
    }

    public static class CombinedProfileFiller
    implements ProfilerFiller {
        private final ProfilerFiller first;
        private final ProfilerFiller second;

        public CombinedProfileFiller(ProfilerFiller var0, ProfilerFiller var1) {
            this.first = var0;
            this.second = var1;
        }

        @Override
        public void startTick() {
            this.first.startTick();
            this.second.startTick();
        }

        @Override
        public void endTick() {
            this.first.endTick();
            this.second.endTick();
        }

        @Override
        public void push(String var0) {
            this.first.push(var0);
            this.second.push(var0);
        }

        @Override
        public void push(Supplier<String> var0) {
            this.first.push(var0);
            this.second.push(var0);
        }

        @Override
        public void markForCharting(MetricCategory var0) {
            this.first.markForCharting(var0);
            this.second.markForCharting(var0);
        }

        @Override
        public void pop() {
            this.first.pop();
            this.second.pop();
        }

        @Override
        public void popPush(String var0) {
            this.first.popPush(var0);
            this.second.popPush(var0);
        }

        @Override
        public void popPush(Supplier<String> var0) {
            this.first.popPush(var0);
            this.second.popPush(var0);
        }

        @Override
        public void incrementCounter(String var0, int var1) {
            this.first.incrementCounter(var0, var1);
            this.second.incrementCounter(var0, var1);
        }

        @Override
        public void incrementCounter(Supplier<String> var0, int var1) {
            this.first.incrementCounter(var0, var1);
            this.second.incrementCounter(var0, var1);
        }

        @Override
        public void addZoneText(String var0) {
            this.first.addZoneText(var0);
            this.second.addZoneText(var0);
        }

        @Override
        public void addZoneValue(long var0) {
            this.first.addZoneValue(var0);
            this.second.addZoneValue(var0);
        }

        @Override
        public void setZoneColor(int var0) {
            this.first.setZoneColor(var0);
            this.second.setZoneColor(var0);
        }
    }
}

