/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ClampedNormalFloat
extends FloatProvider {
    public static final MapCodec<ClampedNormalFloat> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.FLOAT.fieldOf("mean").forGetter(var0 -> Float.valueOf(var0.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(var0 -> Float.valueOf(var0.deviation)), (App)Codec.FLOAT.fieldOf("min").forGetter(var0 -> Float.valueOf(var0.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(var0 -> Float.valueOf(var0.max))).apply((Applicative)var02, ClampedNormalFloat::new)).validate(var0 -> {
        if (var0.max < var0.min) {
            return DataResult.error(() -> "Max must be larger than min: [" + var0.min + ", " + var0.max + "]");
        }
        return DataResult.success((Object)var0);
    });
    private final float mean;
    private final float deviation;
    private final float min;
    private final float max;

    public static ClampedNormalFloat of(float var0, float var1, float var2, float var3) {
        return new ClampedNormalFloat(var0, var1, var2, var3);
    }

    private ClampedNormalFloat(float var0, float var1, float var2, float var3) {
        this.mean = var0;
        this.deviation = var1;
        this.min = var2;
        this.max = var3;
    }

    @Override
    public float sample(RandomSource var0) {
        return ClampedNormalFloat.sample(var0, this.mean, this.deviation, this.min, this.max);
    }

    public static float sample(RandomSource var0, float var1, float var2, float var3, float var4) {
        return Mth.clamp(Mth.normal(var0, var1, var2), var3, var4);
    }

    @Override
    public float getMinValue() {
        return this.min;
    }

    @Override
    public float getMaxValue() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.min + "-" + this.max + "]";
    }
}

